/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class CPU {
    private NES nes;
    private GUI gui;
    private Processor n6502;
    private boolean allowDrawScreen;
    protected boolean cpuActive;
    protected boolean cpuPaused;
    protected boolean cpuRunning;
    protected NESCart currentCart;

    public final void cpuLoadRom(String string) throws InvalidOrUnsupportedROMException {
        this.currentCart = new NESCart(this.gui, this.nes);
        boolean bl = this.currentCart.loadRom(string);
        if (bl) {
            String string2 = "An Error occurred when opening the ROM Image.";
            switch (this.currentCart.getErrorCode()) {
                case 20: {
                    string2 = "The selected file could not be read.";
                    break;
                }
                case 16: {
                    string2 = "The selected file is not a valid iNES Rom File.";
                    break;
                }
                case 18: {
                    String string3 = "Mapper '" + this.currentCart.getMapperName() + '\'';
                    string2 = string3 + " is not currently supported by NESCafe.";
                    break;
                }
                case 19: {
                    DavOS.MsgBox("Missing Program Rom");
                    break;
                }
            }
            this.currentCart = null;
            throw new InvalidOrUnsupportedROMException(string2);
        }
        this.cpuStop();
        this.nes.memory.init(this.currentCart);
        switch (this.currentCart.getMapperNumber()) {
            case 0: {
                this.nes.mapper = new Mapper00();
                break;
            }
            case 1: {
                this.nes.mapper = new Mapper01();
                break;
            }
            case 2: {
                this.nes.mapper = new Mapper02();
                break;
            }
            case 3: {
                this.nes.mapper = new Mapper03();
                break;
            }
            case 4: {
                this.nes.mapper = new Mapper04();
                break;
            }
            case 7: {
                this.nes.mapper = new Mapper07();
                break;
            }
            case 9: {
                this.nes.mapper = new Mapper09();
                break;
            }
            case 40: {
                this.nes.mapper = new Mapper40();
                break;
            }
            default: {
                this.currentCart = null;
                String string4 = "The Hardware could not be located for the Cartridge.";
                throw new InvalidOrUnsupportedROMException(string4);
            }
        }
        this.nes.ppu.latchMapper = false;
        this.nes.mapper.init(this.nes.memory);
        if (this.currentCart.getMapperNumber() > 0) {
            this.gui.writeToScreen("Loading " + this.currentCart.getMapperName() + " Board...");
        } else {
            this.gui.writeToScreen("Loading NES System...");
        }
        this.n6502 = new N6502(this.nes, this.gui);
    }

    public final void cpuReset() {
        if (this.n6502 == null) {
            return;
        }
        if (this.cpuRunning) {
            this.n6502.requestReset();
        }
    }

    public final void cpuRun() {
        if (this.n6502 == null) {
            return;
        }
        this.cpuActive = true;
        this.cpuRunning = true;
        this.n6502.start();
    }

    public final void cpuStop() {
        if (this.n6502 == null) {
            return;
        }
        if (!this.cpuRunning) {
            return;
        }
        this.n6502.stopProcessing();
        this.cpuRunning = false;
    }

    public final void cpuNMI() {
        this.n6502.NMI();
    }

    public final void eatCycles(int n) {
        this.n6502.eatCycles(n);
    }

    public final synchronized void drawScreen(boolean bl) {
        if (!this.allowDrawScreen) {
            return;
        }
        this.gui.tvController.drawScreen(bl);
    }

    public final synchronized void enableDrawScreen(boolean bl) {
        this.allowDrawScreen = bl;
    }

    public final boolean getCPUPause() {
        return this.cpuPaused;
    }

    public final boolean isCPURunning() {
        if (this.n6502 == null) {
            return false;
        }
        return this.cpuActive & this.cpuRunning & (this.cpuPaused ^ true) & this.n6502.getFetchDecodeEnabled();
    }

    public final void setCpuActive(boolean bl) {
        this.cpuActive = bl;
    }

    public final void setCPUPause(boolean bl) {
        this.cpuPaused = bl;
        if (this.gui == null) {
            return;
        }
        if (bl) {
            this.gui.cpuMenu2.setLabel("Unpause Rom");
        } else {
            this.gui.cpuMenu2.setLabel("Pause Rom");
        }
    }

    public final void setFetchDecodeEnable(boolean bl) {
        if (this.n6502 == null) {
            return;
        }
        this.n6502.setFetchDecodeEnabled(bl);
    }

    public final void stateLoad(FileInputStream fileInputStream) throws IOException {
        if (this.n6502 == null) {
            return;
        }
        this.n6502.stateLoad(fileInputStream);
    }

    public final void stateSave(FileOutputStream fileOutputStream) throws IOException {
        if (this.n6502 == null) {
            return;
        }
        this.n6502.stateSave(fileOutputStream);
    }

    private final /* synthetic */ void this() {
        this.allowDrawScreen = true;
        this.cpuActive = false;
        this.cpuPaused = false;
        this.cpuRunning = false;
    }

    public CPU(NES nES, GUI gUI) {
        this.this();
        this.nes = nES;
        this.gui = gUI;
    }
}

