/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class GUI
extends Component {
    private NES nes;
    private GUI gui;
    protected GameGenieWindow gameGenieWindow;
    public boolean loadStateRequest;
    public boolean saveStateRequest;
    public Label statusLabel;
    public Label statusLabel2;
    protected TVController tvController;
    public boolean waitMode;
    Image offscreen;
    Image background;
    public Tiles tiles;
    public Bank bank;
    public Pals pals;
    private Menu menuFile;
    private Menu menuView;
    private Menu menuCPU;
    private Menu menuSound;
    protected MenuItem fileMenu1;
    protected MenuItem fileMenu2;
    protected MenuItem fileMenu3;
    protected MenuItem fileMenu4;
    protected MenuItem fileMenu5;
    protected MenuItem fileMenu6;
    protected MenuItem cpuMenu1;
    protected MenuItem cpuMenu2;
    protected MenuItem cpuMenu4;
    protected MenuItem cpuMenu5;
    protected MenuItem viewMenu1;
    protected MenuItem viewMenu2;
    protected MenuItem viewMenu3;
    protected MenuItem soundMenu1;
    protected MenuItem soundMenu2;
    protected MenuItem soundMenu3;
    protected MenuItem soundMenu4;
    protected MenuItem soundMenu5;
    protected MenuItem soundMenu6;

    private final MenuBar createMenu() {
        Font font = new Font("Helvetica", 0, 12);
        this.fileMenu1.setActionCommand("OPEN");
        this.fileMenu2.setActionCommand("CLOSE");
        this.fileMenu3.setActionCommand("EXIT");
        this.fileMenu4.setActionCommand("SAVEGIF");
        this.fileMenu5.setActionCommand("SAVESTATE");
        this.fileMenu6.setActionCommand("LOADSTATE");
        this.viewMenu1.setActionCommand("FPS");
        this.viewMenu2.setActionCommand("BG");
        this.viewMenu3.setActionCommand("SPRITES");
        this.cpuMenu1.setActionCommand("RESET");
        this.cpuMenu2.setActionCommand("PAUSE");
        this.cpuMenu4.setActionCommand("GAMEGENIE");
        this.cpuMenu5.setActionCommand("UNDOCOPCODES");
        this.soundMenu1.setActionCommand("SOUNDENABLE");
        this.soundMenu2.setActionCommand("SOUNDRECORD");
        this.soundMenu3.setActionCommand("SOUND01");
        this.soundMenu4.setActionCommand("SOUND02");
        this.soundMenu5.setActionCommand("SOUND03");
        this.soundMenu6.setActionCommand("SOUND04");
        this.menuFile.add(this.fileMenu1);
        this.menuFile.add(this.fileMenu2);
        this.menuFile.addSeparator();
        this.menuFile.add(this.fileMenu4);
        this.menuFile.addSeparator();
        this.menuFile.add(this.fileMenu5);
        this.menuFile.add(this.fileMenu6);
        this.menuFile.addSeparator();
        this.menuFile.add(this.fileMenu3);
        this.menuCPU.add(this.cpuMenu1);
        this.menuCPU.add(this.cpuMenu2);
        this.menuCPU.addSeparator();
        this.menuCPU.add(this.cpuMenu5);
        this.menuCPU.addSeparator();
        this.menuCPU.add(this.cpuMenu4);
        this.menuView.add(this.viewMenu1);
        this.menuView.addSeparator();
        this.menuView.add(this.viewMenu2);
        this.menuView.add(this.viewMenu3);
        this.menuSound.add(this.soundMenu1);
        this.menuSound.addSeparator();
        this.menuSound.add(this.soundMenu3);
        this.menuSound.add(this.soundMenu4);
        this.menuSound.add(this.soundMenu5);
        this.menuSound.add(this.soundMenu6);
        this.menuSound.addSeparator();
        this.menuSound.add(this.soundMenu2);
        MenuBar menuBar = new MenuBar();
        menuBar.add(this.menuFile);
        menuBar.add(this.menuCPU);
        menuBar.add(this.menuView);
        menuBar.add(this.menuSound);
        return menuBar;
    }

    public final void init(NES nES) {
        try {
            this.background = DeconstructulatorApplet.getImage("background.gif");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        MenuBar menuBar = this.createMenu();
        this.nes = nES;
        this.gui = this;
        Frame frame = null;
        frame = new Frame();
        GUIWindowAdapter gUIWindowAdapter = new GUIWindowAdapter(this, this.nes);
        frame.addWindowListener(gUIWindowAdapter);
        frame.setLayout(new BorderLayout());
        Font font = new Font("Helvetica", 0, 10);
        GUIKeyListener gUIKeyListener = new GUIKeyListener(this.nes, this.gui);
        frame.addKeyListener(gUIKeyListener);
        boolean bl = true;
        this.statusLabel.setFont(new Font("Helvetica", 0, 10));
        this.statusLabel.setForeground(Color.white);
        this.statusLabel2.setFont(new Font("Helvetica", 0, 10));
        this.statusLabel2.setForeground(Color.darkGray);
        Panel panel = new Panel();
        panel.setBackground(Color.darkGray);
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.statusLabel, "Center");
        Panel panel2 = new Panel();
        panel2.setBackground(Color.darkGray);
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)this.statusLabel2, "Center");
        this.addKeyListener(gUIKeyListener);
        this.tiles = new Tiles();
        this.pals = new Pals();
        this.bank = new Bank();
        frame.add((Component)this, "Center");
        ((Window)frame).setBackground(Color.darkGray);
        Panel panel3 = new Panel(this){
            final /* synthetic */ GUI this$0;

            public final Dimension getPreferredSize() {
                return new Dimension(10, 480);
            }
            {
                this.this$0 = gUI;
            }
        };
        panel3.setBackground(Color.darkGray);
        frame.add((Component)panel3, "West");
        Panel panel4 = new Panel(this){
            final /* synthetic */ GUI this$0;

            public final Dimension getPreferredSize() {
                return new Dimension(10, 480);
            }
            {
                this.this$0 = gUI;
            }
        };
        panel4.setBackground(Color.darkGray);
        frame.add((Component)panel4, "East");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.showMenuNoRom();
        frame.pack();
        Dimension dimension2 = this.getSize();
        frame.setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
        frame.show();
        this.tvController = new TVController(this.nes, this.gui);
    }

    public final void update() {
        this.paint(this.getGraphics());
    }

    public final void update(Graphics graphics) {
        this.paint(graphics);
    }

    public final void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.offscreen == null) {
            this.offscreen = this.createImage(640, 480);
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        graphics2.drawImage(this.background, 0, 0, null);
        if (this.tvController != null && this.tvController.currentImage != null) {
            graphics2.drawImage(this.tvController.currentImage, 161, 108, null);
        }
        this.tiles.paint(graphics2, 417, 73);
        this.pals.paint(graphics2, 170, 289, 353);
        this.bank.paint(graphics2, 1, 75);
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    public final Dimension getPreferredSize() {
        return new Dimension(640, 480);
    }

    public final void pauseSystem(boolean bl) {
        if (!this.nes.isCartRunning()) {
            return;
        }
        this.nes.cpu.enableDrawScreen(bl ^ true);
        this.nes.cpu.setCpuActive(bl ^ true);
        if (bl) {
            this.showBlankDisplay();
        }
    }

    public final void showMenuNoRom() {
        this.fileMenu1.setEnabled(true);
        this.fileMenu2.setEnabled(false);
        this.fileMenu3.setEnabled(true);
        this.fileMenu4.setEnabled(false);
        this.fileMenu5.setEnabled(false);
        this.fileMenu6.setEnabled(false);
        this.cpuMenu1.setEnabled(false);
        this.cpuMenu2.setEnabled(false);
        this.cpuMenu4.setEnabled(false);
        this.viewMenu1.setEnabled(false);
        this.viewMenu2.setEnabled(false);
        this.viewMenu3.setEnabled(false);
        boolean bl = false;
    }

    public final void showMenuRom() {
        this.fileMenu1.setEnabled(true);
        this.fileMenu2.setEnabled(true);
        this.fileMenu3.setEnabled(true);
        this.fileMenu4.setEnabled(true);
        this.fileMenu5.setEnabled(true);
        this.fileMenu6.setEnabled(true);
        this.cpuMenu1.setEnabled(true);
        this.cpuMenu2.setEnabled(true);
        this.cpuMenu4.setEnabled(true);
        this.viewMenu1.setEnabled(true);
        this.viewMenu2.setEnabled(true);
        this.viewMenu3.setEnabled(true);
        boolean bl = false;
    }

    public final void showBlankDisplay() {
        if (this.tvController != null) {
            this.tvController.blankScreen();
        }
    }

    public final void deleteDisplay() {
        if (this.tvController != null) {
            this.tvController.deleteDisplay();
        }
    }

    public final int getScreenX() {
        return 100;
    }

    public final int getScreenY() {
        return 100;
    }

    public final void setGameGenieWindowVisible() {
        if (this.gameGenieWindow == null) {
            try {
                this.gameGenieWindow = new GameGenieWindow(this.nes, this.gui);
            }
            catch (Exception exception) {}
        } else {
            this.gameGenieWindow.setState(0);
            this.gameGenieWindow.show();
        }
    }

    public final void showLoadingScreen(boolean bl) {
        this.waitMode = bl;
        if (bl) {
            this.tvController.drawScreen(true);
        }
    }

    public final void writeToScreen(String string) {
    }

    public final void openFixedRom() {
        GUI gUI = this;
        gUI.pauseSystem(true);
        gUI.setCursor(new Cursor(3));
        gUI.validate();
        System.gc();
        File file = new File("Super Mario.nes");
        gUI.showLoadingScreen(true);
        try {
            gUI.pauseSystem(true);
            gUI.setCursor(new Cursor(3));
            this.nes.cartLoad(file.toString());
            gUI.pauseSystem(false);
            this.nes.lastOpenedCartFileName = file.toString();
        }
        catch (Exception exception) {
            gUI.showLoadingScreen(false);
            gUI.pauseSystem(false);
        }
        gUI.setCursor(new Cursor(0));
        System.gc();
    }

    private final /* synthetic */ void this() {
        this.loadStateRequest = false;
        this.saveStateRequest = false;
        this.statusLabel = new Label();
        this.statusLabel2 = new Label();
        this.waitMode = false;
        this.menuFile = new Menu("File");
        this.menuView = new Menu("View");
        this.menuCPU = new Menu("Nes");
        this.menuSound = new Menu("Sound");
        this.fileMenu1 = new MenuItem("Load Rom...");
        this.fileMenu2 = new MenuItem("Close Rom");
        this.fileMenu3 = new MenuItem("Exit NESCafe");
        this.fileMenu4 = new MenuItem("Save as " + SaveImage.extension);
        this.fileMenu5 = new MenuItem("Commit State");
        this.fileMenu6 = new MenuItem("Rollback to State");
        this.cpuMenu1 = new MenuItem("Reset ROM");
        this.cpuMenu2 = new MenuItem("Pause ROM");
        this.cpuMenu4 = new MenuItem("Enter Game Genie Code...");
        this.cpuMenu5 = new MenuItem("Allow Undocumented OpCodes");
        this.viewMenu1 = new MenuItem("Show FPS Count");
        this.viewMenu2 = new MenuItem("Hide Background");
        this.viewMenu3 = new MenuItem("Hide Sprites");
        this.soundMenu1 = new MenuItem("Disable All Sound");
        this.soundMenu2 = new MenuItem("Start Recording WAV");
        this.soundMenu3 = new MenuItem("Disable Channel 1 (Square)");
        this.soundMenu4 = new MenuItem("Disable Channel 2 (Square)");
        this.soundMenu5 = new MenuItem("Disable Channel 3 (Triangle)");
        this.soundMenu6 = new MenuItem("Disable Channel 4 (Noise)");
    }

    public GUI() {
        this.this();
    }
}

