/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

final class GUIKeyListener
implements KeyListener {
    private NES nes;
    private GUI gui;

    public final void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.getKeyChar() == '\u001b') {
            System.exit(1);
        }
        this.nes.joyPad1.buttonDown(n);
        this.nes.joyPad2.buttonDown(n);
        if (n == 66) {
            this.gui.tvController.toggleBlackWhite();
            return;
        }
        if (n == 45) {
            this.gui.tvController.decTint();
            return;
        }
        if (n == 61) {
            this.gui.tvController.incTint();
            return;
        }
        if (n == 57) {
            this.gui.tvController.decHue();
            return;
        }
        if (n == 48) {
            this.gui.tvController.incHue();
            return;
        }
        if (n == 80 && this.nes.isCartRunning()) {
            this.nes.cpu.setCPUPause(this.nes.cpu.getCPUPause() ^ true);
            return;
        }
        if (n == 82 && this.nes.isCartRunning()) {
            this.nes.reset();
            return;
        }
        boolean bl = false;
        if (n >= 49) {
            bl = true;
        }
        boolean bl2 = false;
        if (n <= 56) {
            bl2 = true;
        }
        if (bl & bl2) {
            this.gui.tvController.setFrameSkip(n - 49);
            this.gui.writeToScreen("Frame Skip = " + (n - 49));
        }
    }

    public final void keyReleased(KeyEvent keyEvent) {
        this.nes.joyPad1.buttonUp(keyEvent.getKeyCode());
        this.nes.joyPad2.buttonUp(keyEvent.getKeyCode());
    }

    public final void keyTyped(KeyEvent keyEvent) {
    }

    public GUIKeyListener(NES nES, GUI gUI) {
        this.nes = nES;
        this.gui = gUI;
    }
}

