/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Mapper04
implements Mapper {
    private MemoryManager mm;
    private int chrOffset;
    private int command;
    private int irqCounter;
    boolean irqEnabled;
    private int irqLatch;
    private boolean irqOccurEnabled;
    private boolean irqSetMode;
    private boolean prghigh;
    private int[] regs;

    public final void init(MemoryManager memoryManager) {
        this.mm = memoryManager;
        this.reset();
    }

    public final void reset() {
        this.chrOffset = 0;
        this.command = 0;
        this.prghigh = false;
        this.irqLatch = 0;
        this.irqCounter = 0;
        this.irqEnabled = false;
        this.irqOccurEnabled = false;
        this.irqSetMode = false;
        int n = 0;
        while (n < this.regs.length) {
            this.regs[n] = 0;
            ++n;
        }
        this.mm.setBankStartAddress(0, 0);
        this.mm.setBankStartAddress(1, 4096);
        this.mm.setBankStartAddress(2, 8192);
        this.mm.setBankStartAddress(3, 12288);
        n = this.mm.getProgramROM().length - 16384;
        this.mm.setBankStartAddress(4, n);
        this.mm.setBankStartAddress(5, n + 4096);
        this.mm.setBankStartAddress(6, n + 8192);
        this.mm.setBankStartAddress(7, n + 12288);
        this.mm.ppu.setPPUBankStartAddress(0, 0);
        this.mm.ppu.setPPUBankStartAddress(1, 1024);
        this.mm.ppu.setPPUBankStartAddress(2, 2048);
        this.mm.ppu.setPPUBankStartAddress(3, 3072);
        this.mm.ppu.setPPUBankStartAddress(4, 4096);
        this.mm.ppu.setPPUBankStartAddress(5, 5120);
        this.mm.ppu.setPPUBankStartAddress(6, 6144);
        this.mm.ppu.setPPUBankStartAddress(7, 7168);
    }

    public final void access(int n, int n2) {
        if (n < 32768) {
            return;
        }
        n2 &= 0xFF;
        switch (n) {
            case 32768: {
                int n3;
                this.chrOffset = 0;
                if ((n2 & 0x80) != 0) {
                    this.chrOffset = 4096;
                }
                boolean bl = false;
                if ((n2 & 0x40) != 0) {
                    bl = this.prghigh = true;
                }
                if ((this.command & 0x80) != (n2 & 0x80)) {
                    n3 = 0;
                    while (n3 < 6) {
                        this.setBanks(n3, this.regs[n3]);
                        ++n3;
                    }
                }
                if ((this.command & 0x40) != (n2 & 0x40)) {
                    n3 = 6;
                    while (n3 < 8) {
                        this.setBanks(n3, this.regs[n3]);
                        ++n3;
                    }
                }
                this.command = n2;
                return;
            }
            case 32769: {
                this.setBanks(this.command, n2);
                return;
            }
            case 40960: {
                if (this.mm.ppu.mirrorFourScreen) {
                    return;
                }
                if ((n2 & 1) != 0) {
                    this.mm.ppu.setMirroring(0, 0, 1, 1);
                } else {
                    this.mm.ppu.setMirroring(0, 1, 0, 1);
                }
                return;
            }
            case 40961: {
                boolean bl = false;
                if ((n2 & 0x80) == 128) {
                    bl = true;
                }
                this.mm.enableSaveRAM = bl;
                return;
            }
            case 49152: {
                this.irqLatch = n2;
                if (this.irqSetMode) {
                    this.irqCounter = this.irqLatch;
                }
                return;
            }
            case 49153: {
                this.irqSetMode = true;
                this.irqCounter = n2;
                return;
            }
            case 57344: {
                this.irqEnabled = false;
                return;
            }
            case 57345: {
                this.irqEnabled = true;
                this.irqOccurEnabled = true;
                return;
            }
        }
    }

    private final void setBanks(int n, int n2) {
        this.regs[n & 7] = n2;
        switch (n & 7) {
            case 0: {
                this.setBankChr2k(0, n2);
                return;
            }
            case 1: {
                this.setBankChr2k(2048, n2);
                return;
            }
            case 2: {
                this.setBankChr1k(4096, n2);
                return;
            }
            case 3: {
                this.setBankChr1k(5120, n2);
                return;
            }
            case 4: {
                this.setBankChr1k(6144, n2);
                return;
            }
            case 5: {
                this.setBankChr1k(7168, n2);
                return;
            }
            case 6: {
                this.setBankPrgA(n2);
                return;
            }
            case 7: {
                this.setBankPrgB(n2);
                return;
            }
        }
    }

    private final void setBankChr2k(int n, int n2) {
        int n3 = n ^ this.chrOffset;
        int n4 = n2 << 10;
        this.mm.ppu.setPPUBankStartAddress(n3 >> 10, n4);
        this.mm.ppu.setPPUBankStartAddress((n3 >> 10) + 1, n4 + 1024);
    }

    private final void setBankChr1k(int n, int n2) {
        int n3 = n ^ this.chrOffset;
        int n4 = n2 << 10;
        this.mm.ppu.setPPUBankStartAddress(n3 >> 10, n4);
    }

    private final void setBankPrgA(int n) {
        int n2 = n << 13;
        int n3 = this.mm.getProgramROM().length - 16384;
        if (this.prghigh) {
            this.mm.setBankStartAddress(0, n3);
            this.mm.setBankStartAddress(1, n3 + 4096);
            this.mm.setBankStartAddress(4, n2);
            this.mm.setBankStartAddress(5, n2 + 4096);
        } else {
            this.mm.setBankStartAddress(0, n2);
            this.mm.setBankStartAddress(1, n2 + 4096);
            this.mm.setBankStartAddress(4, n3);
            this.mm.setBankStartAddress(5, n3 + 4096);
        }
    }

    private final void setBankPrgB(int n) {
        int n2 = n << 13;
        int n3 = this.mm.getProgramROM().length - 16384;
        this.mm.setBankStartAddress(2, n2);
        this.mm.setBankStartAddress(3, n2 + 4096);
        if (this.prghigh) {
            this.mm.setBankStartAddress(0, n3);
            this.mm.setBankStartAddress(1, n3 + 4096);
        } else {
            this.mm.setBankStartAddress(4, n3);
            this.mm.setBankStartAddress(5, n3 + 4096);
        }
    }

    public final void stateLoad(FileInputStream fileInputStream) throws IOException {
        this.chrOffset = fileInputStream.read() & 0xFF;
        this.chrOffset |= (fileInputStream.read() & 0xFF) << 8;
        this.command = fileInputStream.read() & 0xFF;
        this.irqCounter = fileInputStream.read() & 0xFF;
        boolean bl = false;
        if (fileInputStream.read() == 255) {
            bl = true;
        }
        this.irqEnabled = bl;
        this.irqLatch = fileInputStream.read() & 0xFF;
        boolean bl2 = false;
        if (fileInputStream.read() == 255) {
            bl2 = true;
        }
        this.irqOccurEnabled = bl2;
        boolean bl3 = false;
        if (fileInputStream.read() == 255) {
            bl3 = true;
        }
        this.irqSetMode = bl3;
        boolean bl4 = false;
        if (fileInputStream.read() == 255) {
            bl4 = true;
        }
        this.prghigh = bl4;
        int n = 0;
        while (n < this.regs.length) {
            this.regs[n] = fileInputStream.read() & 0xFF;
            ++n;
        }
    }

    public final void stateSave(FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write(this.chrOffset & 0xFF);
        fileOutputStream.write(this.chrOffset >> 8 & 0xFF);
        fileOutputStream.write(this.command & 0xFF);
        fileOutputStream.write(this.irqCounter & 0xFF);
        fileOutputStream.write(this.irqEnabled ? 255 : 0);
        fileOutputStream.write(this.irqLatch & 0xFF);
        fileOutputStream.write(this.irqOccurEnabled ? 255 : 0);
        fileOutputStream.write(this.irqSetMode ? 255 : 0);
        fileOutputStream.write(this.prghigh ? 255 : 0);
        int n = 0;
        while (n < this.regs.length) {
            fileOutputStream.write(this.regs[n] & 0xFF);
            ++n;
        }
    }

    public final int syncH(int n) {
        if ((this.mm.nes.ppu.REG_2001 & 0x18) != 0 && n < 240) {
            --this.irqCounter;
        }
        if (this.irqCounter <= 0) {
            this.irqSetMode = true;
            this.irqCounter = this.irqLatch;
            if (this.irqEnabled && this.irqOccurEnabled) {
                this.irqOccurEnabled = false;
                return 3;
            }
        }
        return 0;
    }

    public final int syncV() {
        return 0;
    }

    public final int getMapperNumber() {
        return 4;
    }

    public final void latch(int n) {
    }

    private final /* synthetic */ void this() {
        this.chrOffset = 0;
        this.command = 0;
        this.irqCounter = 0;
        this.irqEnabled = false;
        this.irqLatch = 0;
        this.irqOccurEnabled = false;
        this.irqSetMode = false;
        this.prghigh = false;
        this.regs = new int[8];
    }

    public Mapper04() {
        this.this();
    }
}

