/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public final class Mapper09
implements Mapper {
    private MemoryManager mm;
    private int Latch0;
    private int Latch1;
    private int Latch0FD;
    private int Latch0FE;
    private int Latch1FD;
    private int Latch1FE;

    public final void stateLoad(FileInputStream fileInputStream) throws IOException {
        this.Latch0 = fileInputStream.read() & 0xFF;
        this.Latch1 = fileInputStream.read() & 0xFF;
        this.Latch0FD = fileInputStream.read() & 0xFF;
        this.Latch0FE = fileInputStream.read() & 0xFF;
        this.Latch1FD = fileInputStream.read() & 0xFF;
        this.Latch1FE = fileInputStream.read() & 0xFF;
    }

    public final void stateSave(FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write(this.Latch0 & 0xFF);
        fileOutputStream.write(this.Latch1 & 0xFF);
        fileOutputStream.write(this.Latch0FD & 0xFF);
        fileOutputStream.write(this.Latch0FE & 0xFF);
        fileOutputStream.write(this.Latch1FD & 0xFF);
        fileOutputStream.write(this.Latch1FE & 0xFF);
    }

    public final void init(MemoryManager memoryManager) {
        this.mm = memoryManager;
        this.mm.ppu.latchMapper = true;
        this.reset();
    }

    public final void reset() {
        this.Latch0FD = 0;
        this.Latch0FE = 4;
        this.Latch1FD = 0;
        this.Latch1FE = 0;
        this.mm.setBankStartAddress(0, 0);
        this.mm.setBankStartAddress(1, 4096);
        int n = this.mm.getProgramROM().length - 24576;
        this.mm.setBankStartAddress(2, n);
        this.mm.setBankStartAddress(3, n + 4096);
        this.mm.setBankStartAddress(4, n + 8192);
        this.mm.setBankStartAddress(5, n + 12288);
        this.mm.setBankStartAddress(6, n + 16384);
        this.mm.setBankStartAddress(7, n + 20480);
        this.Latch0 = 254;
        this.Latch1 = 254;
        this.mm.ppu.setPPUBankStartAddress(0, this.Latch0FE * 4096);
        this.mm.ppu.setPPUBankStartAddress(1, this.Latch0FE * 4096 + 1024);
        this.mm.ppu.setPPUBankStartAddress(2, this.Latch0FE * 4096 + 2048);
        this.mm.ppu.setPPUBankStartAddress(3, this.Latch0FE * 4096 + 3072);
        this.mm.ppu.setPPUBankStartAddress(4, this.Latch1FE * 4096);
        this.mm.ppu.setPPUBankStartAddress(5, this.Latch1FE * 4096 + 1024);
        this.mm.ppu.setPPUBankStartAddress(6, this.Latch1FE * 4096 + 2048);
        this.mm.ppu.setPPUBankStartAddress(7, this.Latch1FE * 4096 + 3072);
    }

    public final int getMapperNumber() {
        return 9;
    }

    public final void access(int n, int n2) {
        if (n < 32768) {
            return;
        }
        n2 &= 0xFF;
        switch (n &= 0xF000) {
            case 40960: {
                this.mm.setBankStartAddress(0, n2 * 8192);
                this.mm.setBankStartAddress(1, n2 * 8192 + 4096);
                return;
            }
            case 45056: {
                this.Latch0FD = n2;
                if (this.Latch0 == 253) {
                    this.mm.ppu.setPPUBankStartAddress(0, n2 * 4096);
                    this.mm.ppu.setPPUBankStartAddress(1, n2 * 4096 + 1024);
                    this.mm.ppu.setPPUBankStartAddress(2, n2 * 4096 + 2048);
                    this.mm.ppu.setPPUBankStartAddress(3, n2 * 4096 + 3072);
                }
                return;
            }
            case 49152: {
                this.Latch0FE = n2;
                if (this.Latch0 == 254) {
                    this.mm.ppu.setPPUBankStartAddress(0, n2 * 4096);
                    this.mm.ppu.setPPUBankStartAddress(1, n2 * 4096 + 1024);
                    this.mm.ppu.setPPUBankStartAddress(2, n2 * 4096 + 2048);
                    this.mm.ppu.setPPUBankStartAddress(3, n2 * 4096 + 3072);
                }
                return;
            }
            case 53248: {
                this.Latch1FD = n2;
                if (this.Latch1 == 253) {
                    this.mm.ppu.setPPUBankStartAddress(4, n2 * 4096);
                    this.mm.ppu.setPPUBankStartAddress(5, n2 * 4096 + 1024);
                    this.mm.ppu.setPPUBankStartAddress(6, n2 * 4096 + 2048);
                    this.mm.ppu.setPPUBankStartAddress(7, n2 * 4096 + 3072);
                }
                return;
            }
            case 57344: {
                this.Latch1FE = n2;
                if (this.Latch1 == 254) {
                    this.mm.ppu.setPPUBankStartAddress(4, n2 * 4096);
                    this.mm.ppu.setPPUBankStartAddress(5, n2 * 4096 + 1024);
                    this.mm.ppu.setPPUBankStartAddress(6, n2 * 4096 + 2048);
                    this.mm.ppu.setPPUBankStartAddress(7, n2 * 4096 + 3072);
                }
                return;
            }
            case 61440: {
                if ((n2 & 1) != 0) {
                    this.mm.ppu.setMirroring(0, 0, 1, 1);
                } else {
                    this.mm.ppu.setMirroring(0, 1, 0, 1);
                }
                return;
            }
        }
    }

    public final void latch(int n) {
        if ((n & 0x1FF0) == 4048 && this.Latch0 != 253) {
            this.mm.ppu.setPPUBankStartAddress(0, this.Latch0FD * 4096);
            this.mm.ppu.setPPUBankStartAddress(1, this.Latch0FD * 4096 + 1024);
            this.mm.ppu.setPPUBankStartAddress(2, this.Latch0FD * 4096 + 2048);
            this.mm.ppu.setPPUBankStartAddress(3, this.Latch0FD * 4096 + 3072);
            this.Latch0 = 253;
        } else if ((n & 0x1FF0) == 4064 && this.Latch0 != 254) {
            this.mm.ppu.setPPUBankStartAddress(0, this.Latch0FE * 4096);
            this.mm.ppu.setPPUBankStartAddress(1, this.Latch0FE * 4096 + 1024);
            this.mm.ppu.setPPUBankStartAddress(2, this.Latch0FE * 4096 + 2048);
            this.mm.ppu.setPPUBankStartAddress(3, this.Latch0FE * 4096 + 3072);
            this.Latch0 = 254;
        } else if ((n & 0x1FF0) == 8144 && this.Latch1 != 253) {
            this.mm.ppu.setPPUBankStartAddress(4, this.Latch1FD * 4096);
            this.mm.ppu.setPPUBankStartAddress(5, this.Latch1FD * 4096 + 1024);
            this.mm.ppu.setPPUBankStartAddress(6, this.Latch1FD * 4096 + 2048);
            this.mm.ppu.setPPUBankStartAddress(7, this.Latch1FD * 4096 + 3072);
            this.Latch1 = 253;
        } else if ((n & 0x1FF0) == 8160 && this.Latch1 != 254) {
            this.mm.ppu.setPPUBankStartAddress(4, this.Latch1FE * 4096);
            this.mm.ppu.setPPUBankStartAddress(5, this.Latch1FE * 4096 + 1024);
            this.mm.ppu.setPPUBankStartAddress(6, this.Latch1FE * 4096 + 2048);
            this.mm.ppu.setPPUBankStartAddress(7, this.Latch1FE * 4096 + 3072);
            this.Latch1 = 254;
        }
    }

    public final int syncH(int n) {
        return 0;
    }

    public final int syncV() {
        return 0;
    }
}

