/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Mapper40
implements Mapper {
    private MemoryManager mm;
    private boolean irqEnabled;
    private int linesToIrq;

    public final void access(int n, int n2) {
        if (n < 32768) {
            return;
        }
        switch (n & 0xE000) {
            case 32768: {
                this.irqEnabled = false;
                this.linesToIrq = 0;
                break;
            }
            case 40960: {
                this.irqEnabled = true;
                this.linesToIrq = 36;
                break;
            }
            case 49152: {
                break;
            }
            case 57344: {
                this.mm.setBankStartAddress(4, (n2 &= 7) << 13);
                this.mm.setBankStartAddress(5, (n2 << 13) + 4096);
                break;
            }
        }
    }

    public final int getMapperNumber() {
        return 40;
    }

    public final void init(MemoryManager memoryManager) {
        this.mm = memoryManager;
        this.reset();
    }

    public final void latch(int n) {
    }

    public final void reset() {
        this.irqEnabled = false;
        this.linesToIrq = 0;
        int n = 0;
        while (n < 8192) {
            this.mm.saveRAM[n] = this.mm.programROM[49152 + n];
            ++n;
        }
        this.mm.setBankStartAddress(0, 32768);
        this.mm.setBankStartAddress(1, 36864);
        this.mm.setBankStartAddress(2, 40960);
        this.mm.setBankStartAddress(3, 45056);
        this.mm.setBankStartAddress(4, 0);
        this.mm.setBankStartAddress(5, 4096);
        this.mm.setBankStartAddress(6, 57344);
        this.mm.setBankStartAddress(7, 61440);
        this.mm.ppu.setPPUBankStartAddress(0, 0);
        this.mm.ppu.setPPUBankStartAddress(1, 1024);
        this.mm.ppu.setPPUBankStartAddress(2, 2048);
        this.mm.ppu.setPPUBankStartAddress(3, 3072);
        this.mm.ppu.setPPUBankStartAddress(4, 4096);
        this.mm.ppu.setPPUBankStartAddress(5, 5120);
        this.mm.ppu.setPPUBankStartAddress(6, 6144);
        this.mm.ppu.setPPUBankStartAddress(7, 7168);
    }

    public final void stateLoad(FileInputStream fileInputStream) throws IOException {
        boolean bl = false;
        if (fileInputStream.read() == 255) {
            bl = true;
        }
        this.irqEnabled = bl;
        this.linesToIrq = fileInputStream.read() & 0xFF;
    }

    public final void stateSave(FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write(this.irqEnabled ? 255 : 0);
        fileOutputStream.write(this.linesToIrq & 0xFF);
    }

    public final int syncH(int n) {
        if (this.irqEnabled && this.linesToIrq-- <= 0) {
            return 3;
        }
        return 0;
    }

    public final int syncV() {
        return 0;
    }

    private final /* synthetic */ void this() {
        this.irqEnabled = false;
        this.linesToIrq = 0;
    }

    public Mapper40() {
        this.this();
    }
}

