/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MemoryManager {
    protected NES nes;
    protected PPU ppu;
    private GUI gui;
    private int[] memory;
    protected int[] programROM;
    protected int[] saveRAM;
    public boolean enableSaveRAM;
    private int[] bank;
    private boolean saveRAMWasLoaded;
    protected GameGenie gameGenie;
    public boolean gameGenieActive;

    public final int getScanline() {
        return this.gui.tvController.scanLine;
    }

    public final void init(NESCart nESCart) {
        this.programROM = nESCart.getProgROM();
        this.nes.ppu.PPUInit(nESCart.getCharROM(), nESCart.getMirroring(), nESCart.getFourScreenNT());
        int n = 0;
        while (n < this.memory.length) {
            this.memory[n] = 0;
            ++n;
        }
        if (nESCart.hasTrainer && nESCart.trainerROM != null) {
            n = 0;
            while (n < 512) {
                this.saveRAM[4096 + n] = nESCart.trainerROM[n];
                ++n;
            }
        } else {
            n = 0;
            while (n < 512) {
                this.saveRAM[4096 + n] = 0;
                ++n;
            }
        }
        if (nESCart.hasSaveRAM) {
            try {
                this.loadSaveRAM();
                this.saveRAMWasLoaded = true;
            }
            catch (Exception exception) {}
        } else {
            this.saveRAMWasLoaded = false;
        }
        this.gameGenie.clearCodes();
        this.gameGenieActive = false;
    }

    public final void loadSaveRAM() throws Exception {
        String string = DavOS.getFileName(this.nes.currentCartFileName) + ".sav";
        FileInputStream fileInputStream = new FileInputStream(string);
        int n = 0;
        while (n < this.saveRAM.length) {
            this.saveRAM[n] = fileInputStream.read() & 0xFF;
            ++n;
        }
        fileInputStream.close();
    }

    public final void saveSaveRAM() {
        if (!this.saveRAMWasLoaded) {
            return;
        }
        try {
            String string = DavOS.getFileName(this.nes.currentCartFileName) + ".sav";
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            int n = 0;
            while (n < this.saveRAM.length) {
                fileOutputStream.write(this.saveRAM[n] & 0xFF);
                ++n;
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void setBankStartAddress(int n, int n2) {
        this.bank[n % 8] = n2 %= this.programROM.length;
    }

    public final int read(int n) {
        int n2;
        if (n < 8192) {
            return this.memory[n & 0x7FF];
        }
        if (n < 16384) {
            return this.nes.ppu.read(n & 0xE007);
        }
        if (n < 16408) {
            switch (n & 0xFF) {
                case 21: {
                    return 0;
                }
                case 22: {
                    return this.nes.joyPad1.readJoyPadBit();
                }
                case 23: {
                    return this.nes.joyPad2.readJoyPadBit();
                }
            }
            return 0;
        }
        if (n < 24576) {
            return n >> 8 & 0xFF;
        }
        if (n < 32768) {
            return this.saveRAM[n - 24576];
        }
        if (this.gameGenieActive && (n2 = this.gameGenie.addressMatch(n)) >= 0) {
            int n3 = this.gameGenie.getValue(n2);
            if (n3 == -1) {
                return this.gameGenie.getValue(n2);
            }
            int n4 = this.bank[((n & 0xF000) >> 12) - 8];
            int n5 = this.programROM[n4 + (n & 0xFFF)];
            if (n5 == n3) {
                return n5;
            }
            return this.gameGenie.getValue(n2);
        }
        try {
            n2 = this.bank[((n & 0xF000) >> 12) - 8];
            return this.programROM[n2 + (n & 0xFFF)];
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public final void write(int n, int n2) {
        if (n < 8192) {
            this.memory[n & 0x7FF] = n2;
            return;
        }
        if (n < 16384) {
            this.nes.ppu.write(n & 0xE007, n2);
            return;
        }
        if (n < 16408) {
            switch (n) {
                case 16384: 
                case 16385: 
                case 16386: 
                case 16387: 
                case 16388: 
                case 16389: 
                case 16390: 
                case 16391: 
                case 16392: 
                case 16393: 
                case 16394: 
                case 16395: 
                case 16396: 
                case 16397: 
                case 16398: 
                case 16399: 
                case 16400: 
                case 16401: 
                case 16402: 
                case 16403: {
                    return;
                }
                case 16404: {
                    int[] nArray = this.memory;
                    int n3 = n2 << 8;
                    switch (n3 & 0xF000) {
                        case 32768: {
                            nArray = this.programROM;
                            n3 = this.bank[(n3 - 32768 >> 12) + (n3 & 0xFFF)];
                            break;
                        }
                        case 24576: 
                        case 28672: {
                            return;
                        }
                        case 20480: {
                            return;
                        }
                        case 8192: 
                        case 12288: 
                        case 16384: {
                            return;
                        }
                        case 0: 
                        case 4096: {
                            nArray = this.memory;
                            n3 &= 0x7FF;
                            break;
                        }
                    }
                    int n4 = 0;
                    while (n4 < 256) {
                        this.nes.ppu.spriteMemory[n4] = nArray[n3] & 0xFF;
                        ++n3;
                        ++n4;
                    }
                    this.nes.cpu.eatCycles(514);
                    return;
                }
                case 16405: {
                    return;
                }
                case 16406: {
                    if ((n2 & 1) == 0) {
                        this.nes.joyPad1.resetJoyPad();
                    }
                    return;
                }
                case 16407: {
                    if ((n2 & 1) == 0) {
                        this.nes.joyPad2.resetJoyPad();
                    }
                    return;
                }
            }
            return;
        }
        if (n < 24576) {
            this.nes.mapper.access(n, n2);
        } else {
            if (n < 32768) {
                this.nes.mapper.access(n, n2);
                if (this.enableSaveRAM) {
                    this.saveRAM[n - 24576] = n2;
                }
                return;
            }
            this.nes.mapper.access(n, n2);
        }
    }

    public final int readWord(int n) {
        return this.read(n) | this.read(n + 1) << 8;
    }

    public final void writeWord(int n, int n2) {
        this.write(n, n2 & 0xFF);
        this.write(n + 1, n2 >> 8);
    }

    public final int[] getProgramROM() {
        return this.programROM;
    }

    public final void stateLoad(FileInputStream fileInputStream) throws IOException {
        int n = 0;
        while (n < this.memory.length) {
            this.memory[n] = fileInputStream.read() & 0xFF;
            ++n;
        }
        n = 0;
        while (n < this.saveRAM.length) {
            this.saveRAM[n] = fileInputStream.read() & 0xFF;
            ++n;
        }
        n = 0;
        while (n < this.bank.length) {
            this.bank[n] = fileInputStream.read() & 0xFF;
            int n2 = n;
            this.bank[n2] = this.bank[n2] | (fileInputStream.read() & 0xFF) << 8;
            int n3 = n;
            this.bank[n3] = this.bank[n3] | (fileInputStream.read() & 0xFF) << 16;
            int n4 = n++;
            this.bank[n4] = this.bank[n4] | (fileInputStream.read() & 0xFF) << 24;
        }
        boolean bl = false;
        if (fileInputStream.read() == 255) {
            bl = true;
        }
        this.enableSaveRAM = bl;
        boolean bl2 = false;
        if (fileInputStream.read() == 255) {
            bl2 = true;
        }
        this.saveRAMWasLoaded = bl2;
    }

    public final void stateSave(FileOutputStream fileOutputStream) throws IOException {
        int n = 0;
        while (n < this.memory.length) {
            fileOutputStream.write(this.memory[n] & 0xFF);
            ++n;
        }
        n = 0;
        while (n < this.saveRAM.length) {
            fileOutputStream.write(this.saveRAM[n] & 0xFF);
            ++n;
        }
        n = 0;
        while (n < this.bank.length) {
            fileOutputStream.write(this.bank[n] & 0xFF);
            fileOutputStream.write(this.bank[n] >> 8 & 0xFF);
            fileOutputStream.write(this.bank[n] >> 16 & 0xFF);
            fileOutputStream.write(this.bank[n] >> 24 & 0xFF);
            ++n;
        }
        fileOutputStream.write(this.enableSaveRAM ? 255 : 0);
        fileOutputStream.write(this.saveRAMWasLoaded ? 255 : 0);
    }

    private final /* synthetic */ void this() {
        this.memory = new int[2048];
        this.programROM = new int[16];
        this.saveRAM = new int[8192];
        this.enableSaveRAM = true;
        this.bank = new int[8];
        this.saveRAMWasLoaded = false;
        this.gameGenie = new GameGenie();
        this.gameGenieActive = false;
    }

    public MemoryManager(NES nES, GUI gUI) {
        this.this();
        this.gui = gUI;
        this.nes = nES;
        this.ppu = this.nes.ppu;
    }
}

