/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class N6502
extends Thread
implements Processor {
    private CPU cpu;
    private NES nes;
    private GUI gui;
    private int A;
    private int X;
    private int Y;
    private int P;
    private int S;
    private int PC;
    private int cyclesPending;
    private final int CYCLES_PER_LINE = 118;
    private boolean resetRequest;
    private boolean stopRequest;
    private boolean stopRequestFulfilled;
    private boolean halted;
    Server server;
    private final int[] cycles;
    private final int[] znTable;

    public final void eatCycles(int n) {
        this.cyclesPending -= n;
    }

    public final void setFetchDecodeEnabled(boolean bl) {
    }

    public final boolean getFetchDecodeEnabled() {
        return true;
    }

    public final void run() {
        this.intReset();
        int n = 1;
        this.stopRequest = false;
        long l = System.currentTimeMillis() + 80L;
        int n2 = 1;
        while (!this.stopRequest) {
            if (n2 > 5) {
                l = System.currentTimeMillis() + 80L;
                n2 = 1;
            }
            this.emulateFrame();
            if (this.resetRequest) {
                this.reset();
            }
            if (n2 == 5) {
                try {
                    Thread.sleep(Math.max(0L, l - System.currentTimeMillis()));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (n != 0 && ++n > 32) {
                this.gui.showLoadingScreen(false);
                n = 0;
            }
            ++n2;
        }
        this.stopRequestFulfilled = true;
    }

    private final void deleteScreen() {
        this.gui.tvController.deleteDisplay();
    }

    private final void drawScreen(boolean bl) {
        this.cpu.drawScreen(bl);
    }

    private final void emulateFrame() {
        this.nes.ppu.startFrame();
        int n = 0;
        while (n < 240) {
            this.emulateCPUCycles(118);
            if (this.nes.mapper.syncH(n) != 0) {
                this.IRQ();
            }
            this.nes.ppu.drawScanLine();
            ++n;
        }
        this.nes.ppu.endFrame();
        n = 240;
        while (n <= 261) {
            if (n == 241) {
                this.nes.ppu.startVBlank();
                this.nes.mapper.syncV();
            }
            if (n == 261) {
                this.nes.ppu.endVBlank();
            }
            if (n == 241) {
                this.emulateCPUCycles(1);
                if (this.nes.ppu.nmiEnabled()) {
                    this.NMI();
                }
                this.emulateCPUCycles(117);
            } else {
                this.emulateCPUCycles(118);
            }
            if (this.nes.mapper.syncH(n) != 0) {
                this.IRQ();
            }
            ++n;
        }
        this.drawScreen(false);
        if (this.gui.saveStateRequest) {
            this.nes.stateSave();
        }
        if (this.gui.loadStateRequest) {
            this.nes.stateLoad();
        }
        this.waitWhileNotActive();
        this.waitWhilePaused();
    }

    public final void NMI() {
        this.pushWord(this.PC);
        this.push(this.P & 0xEF);
        this.PC = this.readWord(65530);
        this.cyclesPending += 7;
    }

    public final void IRQ() {
        if ((this.P & 4) == 0) {
            this.pushWord(this.PC);
            this.push(this.P & 0xEF);
            this.PC = this.readWord(65534);
            this.P |= 4;
            this.cyclesPending += 7;
        }
    }

    private final void emulateCPUCycles(int n) {
        this.cyclesPending += n;
        while (this.cyclesPending > 0) {
            if (!this.halted) {
                this.instructionFetchExecute();
            } else {
                --this.cyclesPending;
            }
            if (!this.stopRequest) continue;
            return;
        }
    }

    private final void instructionFetchExecute() {
        int n = this.read(this.PC++);
        switch (n) {
            case 0: {
                int n2 = this.PC + 1;
                this.pushWord(n2);
                this.push(this.P | 0x10);
                this.PC = this.readWord(65534);
                this.P |= 4;
                this.P |= 0x10;
                break;
            }
            case 169: {
                this.A = this.byImmediate();
                this.setStatusFlags(this.A);
                break;
            }
            case 165: {
                this.A = this.read(this.byZeroPage());
                this.setStatusFlags(this.A);
                break;
            }
            case 181: {
                this.A = this.read(this.byZeroPageX());
                this.setStatusFlags(this.A);
                break;
            }
            case 173: {
                this.A = this.read(this.byAbsolute());
                this.setStatusFlags(this.A);
                break;
            }
            case 189: {
                this.A = this.read(this.byAbsoluteX());
                this.setStatusFlags(this.A);
                break;
            }
            case 185: {
                this.A = this.read(this.byAbsoluteY());
                this.setStatusFlags(this.A);
                break;
            }
            case 161: {
                this.A = this.read(this.byIndirectX());
                this.setStatusFlags(this.A);
                break;
            }
            case 177: {
                this.A = this.read(this.byIndirectY());
                this.setStatusFlags(this.A);
                break;
            }
            case 162: {
                this.X = this.byImmediate();
                this.setStatusFlags(this.X);
                break;
            }
            case 166: {
                this.X = this.read(this.byZeroPage());
                this.setStatusFlags(this.X);
                break;
            }
            case 182: {
                this.X = this.read(this.byZeroPageY());
                this.setStatusFlags(this.X);
                break;
            }
            case 174: {
                this.X = this.read(this.byAbsolute());
                this.setStatusFlags(this.X);
                break;
            }
            case 190: {
                this.X = this.read(this.byAbsoluteY());
                this.setStatusFlags(this.X);
                break;
            }
            case 160: {
                this.Y = this.byImmediate();
                this.setStatusFlags(this.Y);
                break;
            }
            case 164: {
                this.Y = this.read(this.byZeroPage());
                this.setStatusFlags(this.Y);
                break;
            }
            case 180: {
                this.Y = this.read(this.byZeroPageX());
                this.setStatusFlags(this.Y);
                break;
            }
            case 172: {
                this.Y = this.read(this.byAbsolute());
                this.setStatusFlags(this.Y);
                break;
            }
            case 188: {
                this.Y = this.read(this.byAbsoluteX());
                this.setStatusFlags(this.Y);
                break;
            }
            case 167: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.X = this.A = this.read(this.byZeroPage());
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("LAX $aa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 183: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.X = this.A = this.read(this.byZeroPageY());
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("LAX $aa,Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 175: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.X = this.A = this.read(this.byAbsolute());
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("LAX $aaaa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 191: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.X = this.A = this.read(this.byAbsoluteY());
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("LAX $aaaa,Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 163: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.X = this.A = this.read(this.byIndirectX());
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("LAX ($aa,X)");
                this.halted = true;
                --this.PC;
                break;
            }
            case 179: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.X = this.A = this.read(this.byIndirectY());
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("LAX ($aa),Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 133: {
                int n3 = this.byZeroPage();
                this.write(n3, this.A);
                break;
            }
            case 149: {
                int n4 = this.byZeroPageX();
                this.write(n4, this.A);
                break;
            }
            case 141: {
                int n5 = this.byAbsolute();
                this.write(n5, this.A);
                break;
            }
            case 157: {
                int n6 = this.byAbsoluteX();
                this.write(n6, this.A);
                break;
            }
            case 153: {
                int n7 = this.byAbsoluteY();
                this.write(n7, this.A);
                break;
            }
            case 129: {
                int n8 = this.byIndirectX();
                this.write(n8, this.A);
                break;
            }
            case 145: {
                int n9 = this.byIndirectY();
                this.write(n9, this.A);
                break;
            }
            case 134: {
                int n10 = this.byZeroPage();
                this.write(n10, this.X);
                break;
            }
            case 150: {
                int n11 = this.byZeroPageY();
                this.write(n11, this.X);
                break;
            }
            case 142: {
                int n12 = this.byAbsolute();
                this.write(n12, this.X);
                break;
            }
            case 132: {
                int n13 = this.byZeroPage();
                this.write(n13, this.Y);
                break;
            }
            case 148: {
                int n14 = this.byZeroPageX();
                this.write(n14, this.Y);
                break;
            }
            case 140: {
                int n15 = this.byAbsolute();
                this.write(n15, this.Y);
                break;
            }
            case 170: {
                this.X = this.A;
                this.setStatusFlags(this.X);
                break;
            }
            case 168: {
                this.Y = this.A;
                this.setStatusFlags(this.Y);
                break;
            }
            case 186: {
                this.X = this.S & 0xFF;
                this.setStatusFlags(this.X);
                break;
            }
            case 138: {
                this.A = this.X;
                this.setStatusFlags(this.A);
                break;
            }
            case 154: {
                this.S = this.X & 0xFF;
                break;
            }
            case 152: {
                this.A = this.Y;
                this.setStatusFlags(this.A);
                break;
            }
            case 9: {
                this.A |= this.byImmediate();
                this.setStatusFlags(this.A);
                break;
            }
            case 5: {
                int n16 = this.byZeroPage();
                this.A |= this.read(n16);
                this.setStatusFlags(this.A);
                break;
            }
            case 21: {
                int n17 = this.byZeroPageX();
                this.A |= this.read(n17);
                this.setStatusFlags(this.A);
                break;
            }
            case 13: {
                int n18 = this.byAbsolute();
                this.A |= this.read(n18);
                this.setStatusFlags(this.A);
                break;
            }
            case 29: {
                int n19 = this.byAbsoluteX();
                this.A |= this.read(n19);
                this.setStatusFlags(this.A);
                break;
            }
            case 25: {
                int n20 = this.byAbsoluteY();
                this.A |= this.read(n20);
                this.setStatusFlags(this.A);
                break;
            }
            case 1: {
                int n21 = this.byIndirectX();
                this.A |= this.read(n21);
                this.setStatusFlags(this.A);
                break;
            }
            case 17: {
                int n22 = this.byIndirectY();
                this.A |= this.read(n22);
                this.setStatusFlags(this.A);
                break;
            }
            case 41: {
                this.A &= this.byImmediate();
                this.setStatusFlags(this.A);
                break;
            }
            case 37: {
                int n23 = this.byZeroPage();
                this.A &= this.read(n23);
                this.setStatusFlags(this.A);
                break;
            }
            case 53: {
                int n24 = this.byZeroPageX();
                this.A &= this.read(n24);
                this.setStatusFlags(this.A);
                break;
            }
            case 45: {
                int n25 = this.byAbsolute();
                this.A &= this.read(n25);
                this.setStatusFlags(this.A);
                break;
            }
            case 61: {
                int n26 = this.byAbsoluteX();
                this.A &= this.read(n26);
                this.setStatusFlags(this.A);
                break;
            }
            case 57: {
                int n27 = this.byAbsoluteY();
                this.A &= this.read(n27);
                this.setStatusFlags(this.A);
                break;
            }
            case 33: {
                int n28 = this.byIndirectX();
                this.A &= this.read(n28);
                this.setStatusFlags(this.A);
                break;
            }
            case 49: {
                int n29 = this.byIndirectY();
                this.A &= this.read(n29);
                this.setStatusFlags(this.A);
                break;
            }
            case 73: {
                this.A ^= this.byImmediate();
                this.setStatusFlags(this.A);
                break;
            }
            case 69: {
                int n30 = this.byZeroPage();
                this.A ^= this.read(n30);
                this.setStatusFlags(this.A);
                break;
            }
            case 85: {
                int n31 = this.byZeroPageX();
                this.A ^= this.read(n31);
                this.setStatusFlags(this.A);
                break;
            }
            case 77: {
                int n32 = this.byAbsolute();
                this.A ^= this.read(n32);
                this.setStatusFlags(this.A);
                break;
            }
            case 93: {
                int n33 = this.byAbsoluteX();
                this.A ^= this.read(n33);
                this.setStatusFlags(this.A);
                break;
            }
            case 89: {
                int n34 = this.byAbsoluteY();
                this.A ^= this.read(n34);
                this.setStatusFlags(this.A);
                break;
            }
            case 65: {
                int n35 = this.byIndirectX();
                this.A ^= this.read(n35);
                this.setStatusFlags(this.A);
                break;
            }
            case 81: {
                int n36 = this.byIndirectY();
                this.A ^= this.read(n36);
                this.setStatusFlags(this.A);
                break;
            }
            case 36: {
                this.operateBit(this.read(this.byZeroPage()));
                break;
            }
            case 44: {
                this.operateBit(this.read(this.byAbsolute()));
                break;
            }
            case 7: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n37 = this.byZeroPage();
                    int n38 = this.ASL(this.read(n37));
                    this.write(n37, n38);
                    this.A |= n38;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("ASO $aa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 10: {
                this.A = this.ASL(this.A);
                break;
            }
            case 6: {
                int n39 = this.byZeroPage();
                int n40 = this.read(n39);
                this.write(n39, n40);
                n40 = this.ASL(n40);
                this.write(n39, n40);
                break;
            }
            case 22: {
                int n41 = this.byZeroPageX();
                int n42 = this.read(n41);
                this.write(n41, n42);
                n42 = this.ASL(n42);
                this.write(n41, n42);
                break;
            }
            case 14: {
                int n43 = this.byAbsolute();
                int n44 = this.read(n43);
                this.write(n43, n44);
                n44 = this.ASL(n44);
                this.write(n43, n44);
                break;
            }
            case 30: {
                int n45 = this.byAbsoluteX();
                int n46 = this.read(n45);
                this.write(n45, n46);
                n46 = this.ASL(n46);
                this.write(n45, n46);
                break;
            }
            case 23: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n47 = this.byZeroPageX();
                    int n48 = this.ASL(this.read(n47));
                    this.write(n47, n48);
                    this.A |= n48;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("ASO $aa,X");
                this.halted = true;
                --this.PC;
                break;
            }
            case 15: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n49 = this.byAbsolute();
                    int n50 = this.ASL(this.read(n49));
                    this.write(n49, n50);
                    this.A |= n50;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("ASO $aaaa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 31: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n51 = this.byAbsoluteX();
                    int n52 = this.ASL(this.read(n51));
                    this.write(n51, n52);
                    this.A |= n52;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("ASO $aaaa,X");
                this.halted = true;
                --this.PC;
                break;
            }
            case 27: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n53 = this.byAbsoluteY();
                    int n54 = this.ASL(this.read(n53));
                    this.write(n53, n54);
                    this.A |= n54;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("ASO $aaaa,Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 3: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n55 = this.byIndirectX();
                    int n56 = this.ASL(this.read(n55));
                    this.write(n55, n56);
                    this.A |= n56;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("ASO ($aa,X)");
                this.halted = true;
                --this.PC;
                break;
            }
            case 19: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n57 = this.byIndirectY();
                    int n58 = this.ASL(this.read(n57));
                    this.write(n57, n58);
                    this.A |= n58;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("ASO ($aa),Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 74: {
                this.A = this.LSR(this.A);
                break;
            }
            case 70: {
                int n59 = this.byZeroPage();
                int n60 = this.read(n59);
                this.write(n59, n60);
                n60 = this.LSR(n60);
                this.write(n59, n60);
                break;
            }
            case 86: {
                int n61 = this.byZeroPageX();
                int n62 = this.read(n61);
                this.write(n61, n62);
                n62 = this.LSR(n62);
                this.write(n61, n62);
                break;
            }
            case 78: {
                int n63 = this.byAbsolute();
                int n64 = this.read(n63);
                this.write(n63, n64);
                n64 = this.LSR(n64);
                this.write(n63, n64);
                break;
            }
            case 94: {
                int n65 = this.byAbsoluteX();
                int n66 = this.read(n65);
                this.write(n65, n66);
                n66 = this.LSR(n66);
                this.write(n65, n66);
                break;
            }
            case 71: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n67 = this.byZeroPage();
                    int n68 = this.LSR(this.read(n67));
                    this.write(n67, n68);
                    this.A ^= n68;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("LSE $aa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 87: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n69 = this.byZeroPageX();
                    int n70 = this.LSR(this.read(n69));
                    this.write(n69, n70);
                    this.A ^= n70;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("LSE $aa,X");
                this.halted = true;
                --this.PC;
                break;
            }
            case 79: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n71 = this.byAbsolute();
                    int n72 = this.LSR(this.read(n71));
                    this.write(n71, n72);
                    this.A ^= n72;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("LSE $aaaa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 95: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n73 = this.byAbsoluteX();
                    int n74 = this.LSR(this.read(n73));
                    this.write(n73, n74);
                    this.A ^= n74;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("LSE $aaaa,X");
                this.halted = true;
                --this.PC;
                break;
            }
            case 91: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n75 = this.byAbsoluteY();
                    int n76 = this.LSR(this.read(n75));
                    this.write(n75, n76);
                    this.A ^= n76;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("LSE $aaaa,Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 67: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n77 = this.byIndirectX();
                    int n78 = this.LSR(this.read(n77));
                    this.write(n77, n78);
                    this.A ^= n78;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("LSE ($aa,X)");
                this.halted = true;
                --this.PC;
                break;
            }
            case 83: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n79 = this.byIndirectY();
                    int n80 = this.LSR(this.read(n79));
                    this.write(n79, n80);
                    this.A ^= n80;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("LSE ($aa,Y)");
                this.halted = true;
                --this.PC;
                break;
            }
            case 42: {
                this.A = this.ROL(this.A);
                break;
            }
            case 38: {
                int n81 = this.byZeroPage();
                int n82 = this.read(n81);
                this.write(n81, n82);
                n82 = this.ROL(n82);
                this.write(n81, n82);
                break;
            }
            case 54: {
                int n83 = this.byZeroPageX();
                int n84 = this.read(n83);
                this.write(n83, n84);
                n84 = this.ROL(n84);
                this.write(n83, n84);
                break;
            }
            case 46: {
                int n85 = this.byAbsolute();
                int n86 = this.read(n85);
                this.write(n85, n86);
                n86 = this.ROL(n86);
                this.write(n85, n86);
                break;
            }
            case 62: {
                int n87 = this.byAbsoluteX();
                int n88 = this.read(n87);
                this.write(n87, n88);
                n88 = this.ROL(n88);
                this.write(n87, n88);
                break;
            }
            case 39: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n89 = this.byZeroPage();
                    int n90 = this.ROL(this.read(n89));
                    this.write(n89, n90);
                    this.A &= n90;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("RLA $aa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 55: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n91 = this.byZeroPageX();
                    int n92 = this.ROL(this.read(n91));
                    this.write(n91, n92);
                    this.A &= n92;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("RLA $aa,X");
                this.halted = true;
                --this.PC;
                break;
            }
            case 47: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n93 = this.byAbsolute();
                    int n94 = this.ROL(this.read(n93));
                    this.write(n93, n94);
                    this.A &= n94;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("RLA $aaaa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 63: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n95 = this.byAbsoluteX();
                    int n96 = this.ROL(this.read(n95));
                    this.write(n95, n96);
                    this.A &= n96;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("RLA $aaaa,X");
                this.halted = true;
                --this.PC;
                break;
            }
            case 59: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n97 = this.byAbsoluteY();
                    int n98 = this.ROL(this.read(n97));
                    this.write(n97, n98);
                    this.A &= n98;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("RLA $aaaa,Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 35: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n99 = this.byIndirectX();
                    int n100 = this.ROL(this.read(n99));
                    this.write(n99, n100);
                    this.A &= n100;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("RLA ($aa,X)");
                this.halted = true;
                --this.PC;
                break;
            }
            case 51: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n101 = this.byIndirectY();
                    int n102 = this.ROL(this.read(n101));
                    this.write(n101, n102);
                    this.A &= n102;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("RLA ($aa),Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 106: {
                this.A = this.ROR(this.A);
                break;
            }
            case 102: {
                int n103 = this.byZeroPage();
                int n104 = this.read(n103);
                this.write(n103, n104);
                n104 = this.ROR(n104);
                this.write(n103, n104);
                break;
            }
            case 103: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n105 = this.byZeroPage();
                    int n106 = this.ROR(this.read(n105));
                    this.write(n105, n106);
                    this.operateAdd(n105);
                    break;
                }
                this.usedUndocumentedCode("RRA $aa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 118: {
                int n107 = this.byZeroPageX();
                int n108 = this.read(n107);
                this.write(n107, n108);
                n108 = this.ROR(n108);
                this.write(n107, n108);
                break;
            }
            case 119: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n109 = this.byZeroPageX();
                    int n110 = this.ROR(this.read(n109));
                    this.write(n109, n110);
                    this.operateAdd(n109);
                    break;
                }
                this.usedUndocumentedCode("RRA $aa,X");
                this.halted = true;
                --this.PC;
                break;
            }
            case 110: {
                int n111 = this.byAbsolute();
                int n112 = this.read(n111);
                this.write(n111, n112);
                n112 = this.ROR(n112);
                this.write(n111, n112);
                break;
            }
            case 111: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n113 = this.byAbsolute();
                    int n114 = this.ROR(this.read(n113));
                    this.write(n113, n114);
                    this.operateAdd(n113);
                    break;
                }
                this.usedUndocumentedCode("RRA $aaaa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 126: {
                int n115 = this.byAbsoluteX();
                int n116 = this.read(n115);
                this.write(n115, n116);
                n116 = this.ROR(n116);
                this.write(n115, n116);
                break;
            }
            case 127: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n117 = this.byAbsoluteX();
                    int n118 = this.ROR(this.read(n117));
                    this.write(n117, n118);
                    this.operateAdd(n117);
                    break;
                }
                this.usedUndocumentedCode("RRA $aaaa,X");
                this.halted = true;
                --this.PC;
                break;
            }
            case 123: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n119 = this.byAbsoluteY();
                    int n120 = this.ROR(this.read(n119));
                    this.write(n119, n120);
                    this.operateAdd(n119);
                    break;
                }
                this.usedUndocumentedCode("RRA $aaaa,Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 99: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n121 = this.byIndirectX();
                    int n122 = this.ROR(this.read(n121));
                    this.write(n121, n122);
                    this.operateAdd(n121);
                    break;
                }
                this.usedUndocumentedCode("RRA ($aa,X)");
                this.halted = true;
                --this.PC;
                break;
            }
            case 115: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n123 = this.byIndirectY();
                    int n124 = this.ROR(this.read(n123));
                    this.write(n123, n124);
                    this.operateAdd(n123);
                    break;
                }
                this.usedUndocumentedCode("RRA ($aa),Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 144: {
                this.branch("BCC", 1, false);
                break;
            }
            case 176: {
                this.branch("BCS", 1, true);
                break;
            }
            case 208: {
                this.branch("BNE", 2, false);
                break;
            }
            case 240: {
                this.branch("BEQ", 2, true);
                break;
            }
            case 16: {
                this.branch("BPL", 128, false);
                break;
            }
            case 48: {
                this.branch("BMI", 128, true);
                break;
            }
            case 80: {
                this.branch("BVC", 64, false);
                break;
            }
            case 112: {
                this.branch("BVS", 64, true);
                break;
            }
            case 76: {
                this.PC = this.byAbsolute();
                break;
            }
            case 108: {
                int n125 = this.byAbsolute();
                if ((n125 & 0xFF) == 255) {
                    n125 = this.read(n125 & 0xFF00) | this.read(n125);
                }
                this.PC = this.readWord(n125);
                break;
            }
            case 32: {
                int n126 = this.PC + 1;
                this.pushWord(n126);
                this.PC = this.byAbsolute();
                break;
            }
            case 96: {
                this.PC = this.popWord() + 1;
                break;
            }
            case 64: {
                this.P = this.pop();
                this.PC = this.popWord();
                break;
            }
            case 72: {
                this.push(this.A);
                break;
            }
            case 8: {
                this.push(this.P | 0x10);
                break;
            }
            case 104: {
                this.A = this.pop();
                this.setStatusFlags(this.A);
                break;
            }
            case 40: {
                this.P = this.pop();
                break;
            }
            case 24: {
                this.P &= 0xFE;
                break;
            }
            case 216: {
                this.P &= 0xF7;
                break;
            }
            case 88: {
                this.P &= 0xFB;
                break;
            }
            case 184: {
                this.P &= 0xBF;
                break;
            }
            case 56: {
                this.P |= 1;
                break;
            }
            case 248: {
                this.P |= 8;
                break;
            }
            case 120: {
                this.P |= 4;
                break;
            }
            case 230: {
                int n127 = this.byZeroPage();
                int n128 = this.read(n127);
                this.write(n127, n128);
                n128 = this.increment(n128);
                this.write(n127, n128);
                break;
            }
            case 246: {
                int n129 = this.byZeroPageX();
                int n130 = this.read(n129);
                this.write(n129, n130);
                n130 = this.increment(this.read(n129));
                this.write(n129, n130);
                break;
            }
            case 238: {
                int n131 = this.byAbsolute();
                int n132 = this.read(n131);
                this.write(n131, n132);
                n132 = this.increment(this.read(n131));
                this.write(n131, n132);
                break;
            }
            case 254: {
                int n133 = this.byAbsoluteX();
                int n134 = this.read(n133);
                this.write(n133, n134);
                n134 = this.increment(this.read(n133));
                this.write(n133, n134);
                break;
            }
            case 232: {
                ++this.X;
                this.X &= 0xFF;
                this.setStatusFlags(this.X);
                break;
            }
            case 200: {
                ++this.Y;
                this.Y &= 0xFF;
                this.setStatusFlags(this.Y);
                break;
            }
            case 198: {
                int n135 = this.byZeroPage();
                int n136 = this.read(n135);
                this.write(n135, n136);
                n136 = this.decrement(this.read(n135));
                this.write(n135, n136);
                break;
            }
            case 214: {
                int n137 = this.byZeroPageX();
                int n138 = this.read(n137);
                this.write(n137, n138);
                n138 = this.decrement(this.read(n137));
                this.write(n137, n138);
                break;
            }
            case 206: {
                int n139 = this.byAbsolute();
                int n140 = this.read(n139);
                this.write(n139, n140);
                n140 = this.decrement(this.read(n139));
                this.write(n139, n140);
                break;
            }
            case 222: {
                int n141 = this.byAbsoluteX();
                int n142 = this.read(n141);
                this.write(n141, n142);
                n142 = this.decrement(this.read(n141));
                this.write(n141, n142);
                break;
            }
            case 202: {
                --this.X;
                this.X &= 0xFF;
                this.setStatusFlags(this.X);
                break;
            }
            case 136: {
                --this.Y;
                this.Y &= 0xFF;
                this.setStatusFlags(this.Y);
                break;
            }
            case 105: {
                this.operateAdd(this.byImmediate());
                break;
            }
            case 101: {
                this.operateAdd(this.read(this.byZeroPage()));
                break;
            }
            case 117: {
                this.operateAdd(this.read(this.byZeroPageX()));
                break;
            }
            case 109: {
                this.operateAdd(this.read(this.byAbsolute()));
                break;
            }
            case 125: {
                this.operateAdd(this.read(this.byAbsoluteX()));
                break;
            }
            case 121: {
                this.operateAdd(this.read(this.byAbsoluteY()));
                break;
            }
            case 97: {
                this.operateAdd(this.read(this.byIndirectX()));
                break;
            }
            case 113: {
                this.operateAdd(this.read(this.byIndirectY()));
                break;
            }
            case 233: 
            case 235: {
                this.operateSub(this.byImmediate());
                break;
            }
            case 229: {
                this.operateSub(this.read(this.byZeroPage()));
                break;
            }
            case 245: {
                this.operateSub(this.read(this.byZeroPageX()));
                break;
            }
            case 237: {
                this.operateSub(this.read(this.byAbsolute()));
                break;
            }
            case 253: {
                this.operateSub(this.read(this.byAbsoluteX()));
                break;
            }
            case 249: {
                this.operateSub(this.read(this.byAbsoluteY()));
                break;
            }
            case 225: {
                this.operateSub(this.read(this.byIndirectX()));
                break;
            }
            case 241: {
                this.operateSub(this.read(this.byIndirectY()));
                break;
            }
            case 239: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.operateCmp(this.A, this.increment(this.byAbsolute()));
                    break;
                }
                this.usedUndocumentedCode("INS aaaa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 255: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.operateCmp(this.A, this.increment(this.byAbsoluteX()));
                    break;
                }
                this.usedUndocumentedCode("INS aaaa,X");
                this.halted = true;
                --this.PC;
                break;
            }
            case 251: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.operateCmp(this.A, this.increment(this.byAbsoluteY()));
                    break;
                }
                this.usedUndocumentedCode("INS aaaa,Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 231: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.operateCmp(this.A, this.increment(this.byZeroPage()));
                    break;
                }
                this.usedUndocumentedCode("INS aa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 247: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.operateCmp(this.A, this.increment(this.byZeroPageX()));
                    break;
                }
                this.usedUndocumentedCode("INS aa,X");
                this.halted = true;
                --this.PC;
                break;
            }
            case 227: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.operateCmp(this.A, this.increment(this.byIndirectX()));
                    break;
                }
                this.usedUndocumentedCode("INS (aa,X)");
                this.halted = true;
                --this.PC;
                break;
            }
            case 243: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.operateCmp(this.A, this.increment(this.byIndirectY()));
                    break;
                }
                this.usedUndocumentedCode("INS (aa),Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 201: {
                this.operateCmp(this.A, this.byImmediate());
                break;
            }
            case 197: {
                this.operateCmp(this.A, this.read(this.byZeroPage()));
                break;
            }
            case 213: {
                this.operateCmp(this.A, this.read(this.byZeroPageX()));
                break;
            }
            case 205: {
                this.operateCmp(this.A, this.read(this.byAbsolute()));
                break;
            }
            case 221: {
                this.operateCmp(this.A, this.read(this.byAbsoluteX()));
                break;
            }
            case 217: {
                this.operateCmp(this.A, this.read(this.byAbsoluteY()));
                break;
            }
            case 193: {
                this.operateCmp(this.A, this.read(this.byIndirectX()));
                break;
            }
            case 209: {
                this.operateCmp(this.A, this.read(this.byIndirectY()));
                break;
            }
            case 224: {
                this.operateCmp(this.X, this.byImmediate());
                break;
            }
            case 228: {
                this.operateCmp(this.X, this.read(this.byZeroPage()));
                break;
            }
            case 236: {
                this.operateCmp(this.X, this.read(this.byAbsolute()));
                break;
            }
            case 192: {
                this.operateCmp(this.Y, this.byImmediate());
                break;
            }
            case 196: {
                this.operateCmp(this.Y, this.read(this.byZeroPage()));
                break;
            }
            case 204: {
                this.operateCmp(this.Y, this.read(this.byAbsolute()));
                break;
            }
            case 143: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n143 = this.byAbsolute();
                    int n144 = this.A & this.X;
                    this.write(n143, n144);
                    break;
                }
                this.usedUndocumentedCode("AXS $aaaa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 135: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n145 = this.byZeroPage();
                    int n146 = this.A & this.X;
                    this.write(n145, n146);
                    break;
                }
                this.usedUndocumentedCode("AXS $aa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 151: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n147 = this.byZeroPageY();
                    int n148 = this.A & this.X;
                    this.write(n147, n148);
                    break;
                }
                this.usedUndocumentedCode("AXS $aa,Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 131: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n149 = this.byIndirectX();
                    int n150 = this.A & this.X;
                    this.write(n149, n150);
                    break;
                }
                this.usedUndocumentedCode("AXS $aa,X");
                this.halted = true;
                --this.PC;
                break;
            }
            case 203: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.X = (this.A & this.X) - this.byImmediate();
                    int n151 = 0;
                    if (this.X < 0) {
                        n151 = 1;
                    }
                    this.P |= 1 - n151;
                    this.X &= 0xFF;
                    this.setStatusFlags(this.X);
                    break;
                }
                this.usedUndocumentedCode("SAX #aa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 171: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.A |= 0xEE;
                    this.A &= this.byImmediate();
                    this.X = this.A;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("OAL #aa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 75: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n152 = this.A & this.byImmediate();
                    this.A = this.LSR(this.A);
                    break;
                }
                this.usedUndocumentedCode("ALR #aa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 107: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n153 = this.A & this.byImmediate();
                    this.A = this.ROR(this.A);
                    break;
                }
                this.usedUndocumentedCode("ARR #aa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 139: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.A = this.X & this.byImmediate();
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("XAA #aa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 207: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n154 = this.byAbsolute();
                    int n155 = this.read(n154) - 1 & 0xFF;
                    this.operateCmp(this.A, n155);
                    this.write(n154, n155);
                    break;
                }
                this.usedUndocumentedCode("DCM aaaa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 223: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n156 = this.byAbsoluteX();
                    int n157 = this.read(n156) - 1 & 0xFF;
                    this.operateCmp(this.A, n157);
                    this.write(n156, n157);
                    break;
                }
                this.usedUndocumentedCode("DCM aaaa,X");
                this.halted = true;
                --this.PC;
                break;
            }
            case 219: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n158 = this.byAbsoluteY();
                    int n159 = this.read(n158) - 1 & 0xFF;
                    this.operateCmp(this.A, n159);
                    this.write(n158, n159);
                    break;
                }
                this.usedUndocumentedCode("DCM $aaaa,Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 199: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n160 = this.byZeroPage();
                    int n161 = this.read(n160) - 1 & 0xFF;
                    this.operateCmp(this.A, n161);
                    this.write(n160, n161);
                    break;
                }
                this.usedUndocumentedCode("DCM $aa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 215: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n162 = this.byZeroPageX();
                    int n163 = this.read(n162) - 1 & 0xFF;
                    this.operateCmp(this.A, n163);
                    this.write(n162, n163);
                    break;
                }
                this.usedUndocumentedCode("DCM $aa,X");
                this.halted = true;
                --this.PC;
                break;
            }
            case 195: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n164 = this.byIndirectX();
                    int n165 = this.read(n164) - 1 & 0xFF;
                    this.operateCmp(this.A, n165);
                    this.write(n164, n165);
                    break;
                }
                this.usedUndocumentedCode("DCM (aa,X)");
                this.halted = true;
                --this.PC;
                break;
            }
            case 211: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n166 = this.byIndirectY();
                    int n167 = this.read(n166) - 1 & 0xFF;
                    this.operateCmp(this.A, n167);
                    this.write(n166, n167);
                    break;
                }
                this.usedUndocumentedCode("DCM (aa),Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 187: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n168 = this.byAbsoluteY();
                    this.X = this.A = this.read(n168) & this.S;
                    this.S = this.A;
                    this.setStatusFlags(this.A);
                    break;
                }
                this.usedUndocumentedCode("LAS aaaa,Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 11: 
            case 43: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n169 = this.byImmediate();
                    int n170 = this.read(n169) & this.A;
                    this.setStatusFlags(n170);
                    this.P |= (this.P & 0x80) >> 7;
                    break;
                }
                this.usedUndocumentedCode("ANC #aa");
                this.halted = true;
                --this.PC;
                break;
            }
            case 155: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.S = this.X & this.A;
                    int n171 = this.byAbsoluteY();
                    int n172 = ((n171 & 0xFF00) >> 8) + 1;
                    this.write(n171, n172 &= this.S);
                    break;
                }
                this.usedUndocumentedCode("TAS $aaaa,Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 156: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n173 = this.byAbsoluteX();
                    int n174 = ((n173 & 0xFF00) >> 8) + 1;
                    this.write(n173, n174 &= this.Y);
                    break;
                }
                this.usedUndocumentedCode("SAY $aaaa,X");
                this.halted = true;
                --this.PC;
                break;
            }
            case 158: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n175 = this.byAbsoluteY();
                    int n176 = ((n175 & 0xFF00) >> 8) + 1;
                    this.write(n175, n176 &= this.X);
                    break;
                }
                this.usedUndocumentedCode("XAS aaaa,Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 159: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n177 = this.byAbsoluteY();
                    int n178 = ((n177 & 0xFF00) >> 8) + 1;
                    n178 &= this.X;
                    this.write(n177, n178 &= this.A);
                    break;
                }
                this.usedUndocumentedCode("AXA aaaa,Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 147: {
                if (this.nes.useUndocumentedOpCodes) {
                    int n179 = this.byIndirectY();
                    int n180 = ((n179 & 0xFF00) >> 8) + 1;
                    n180 &= this.X;
                    this.write(n179, n180 &= this.A);
                    break;
                }
                this.usedUndocumentedCode("AXA (aa),Y");
                this.halted = true;
                --this.PC;
                break;
            }
            case 4: 
            case 20: 
            case 52: 
            case 68: 
            case 84: 
            case 100: 
            case 116: 
            case 128: 
            case 130: 
            case 137: 
            case 194: 
            case 212: 
            case 226: 
            case 244: {
                if (this.nes.useUndocumentedOpCodes) {
                    ++this.PC;
                    break;
                }
                this.usedUndocumentedCode("SKB");
                this.halted = true;
                --this.PC;
                break;
            }
            case 12: 
            case 28: 
            case 60: 
            case 92: 
            case 124: 
            case 220: 
            case 252: {
                if (this.nes.useUndocumentedOpCodes) {
                    this.PC += 2;
                    break;
                }
                this.usedUndocumentedCode("SKW");
                this.halted = true;
                --this.PC;
                break;
            }
            case 26: 
            case 58: 
            case 90: 
            case 122: 
            case 218: 
            case 234: 
            case 250: {
                break;
            }
            case 2: 
            case 18: 
            case 34: 
            case 50: 
            case 66: 
            case 82: 
            case 98: 
            case 114: 
            case 146: 
            case 178: 
            case 210: 
            case 242: {
                this.halted = true;
                --this.PC;
                break;
            }
            default: {
                --this.PC;
            }
        }
        this.cyclesPending -= this.cycles[n];
    }

    private final void reset() {
        this.resetRequest = false;
        this.nes.memory.saveSaveRAM();
        this.nes.memory.init(this.nes.cpu.currentCart);
        this.nes.mapper.init(this.nes.memory);
        this.intReset();
        this.gui.writeToScreen("Cartridge Reset");
    }

    public final void requestReset() {
        this.resetRequest = true;
    }

    private final void intReset() {
        this.A = 0;
        this.X = 0;
        this.Y = 0;
        this.P = 4;
        this.S = 255;
        this.halted = false;
        this.PC = this.readWord(65532);
    }

    public final void stopProcessing() {
        this.stopRequest = true;
        try {
            N6502.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void waitWhileNotActive() {
        while (!this.cpu.cpuActive) {
            this.deleteScreen();
            if (this.stopRequest) {
                return;
            }
            if (this.gui.loadStateRequest) {
                this.nes.stateLoad();
            }
            if (this.gui.saveStateRequest) {
                this.nes.stateSave();
            }
            try {
                N6502.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void waitWhilePaused() {
        while (this.cpu.cpuPaused) {
            System.out.println("waiting while paused");
            this.drawScreen(true);
            if (this.stopRequest) {
                return;
            }
            if (this.gui.saveStateRequest) {
                this.nes.stateSave();
            }
            if (this.gui.loadStateRequest) {
                this.nes.stateLoad();
            }
            try {
                N6502.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final int read(int n) {
        return this.nes.memory.read(n);
    }

    private final int readWord(int n) {
        return this.nes.memory.readWord(n);
    }

    private final void write(int n, int n2) {
        this.nes.memory.write(n, n2);
    }

    private final void writeWord(int n, int n2) {
        this.nes.memory.writeWord(n, n2);
    }

    private final int byImmediate() {
        return this.read(this.PC++);
    }

    private final int byAbsolute() {
        int n = this.readWord(this.PC);
        this.PC += 2;
        return n;
    }

    private final int byAbsoluteY() {
        int n = this.byAbsolute();
        int n2 = n + this.Y;
        this.checkPageBoundaryCrossing(n, n2);
        return n2;
    }

    private final int byAbsoluteX() {
        int n = this.byAbsolute();
        int n2 = n + this.X;
        this.checkPageBoundaryCrossing(n, n2);
        return n2;
    }

    private final int byZeroPage() {
        int n = this.read(this.PC++);
        return n;
    }

    private final int byZeroPageX() {
        int n = this.read(this.PC++);
        return n + this.X & 0xFF;
    }

    private final int byZeroPageY() {
        int n = this.read(this.PC++);
        return n + this.Y & 0xFF;
    }

    private final int byIndirectX() {
        int n = this.read(this.PC++);
        n += this.X;
        return this.readWord(n &= 0xFF);
    }

    private final int byIndirectY() {
        int n = this.read(this.PC++);
        n = this.readWord(n);
        this.checkPageBoundaryCrossing(n, n + this.Y);
        return n + this.Y;
    }

    private final void checkPageBoundaryCrossing(int n, int n2) {
        if (((n2 ^ n) & 0x100) != 0) {
            --this.cyclesPending;
        }
    }

    private final void setStatusFlags(int n) {
        this.P &= 0x7D;
        this.P |= this.znTable[n];
    }

    private final int ASL(int n) {
        this.P &= 0x7C;
        this.P |= n >> 7;
        n <<= 1;
        this.P |= this.znTable[n &= 0xFF];
        return n;
    }

    private final int LSR(int n) {
        this.P &= 0x7C;
        this.P |= n & 1;
        this.P |= this.znTable[n >>= 1];
        return n;
    }

    private final int ROL(int n) {
        n <<= 1;
        this.P &= 0x7C;
        this.P |= (n |= this.P & 1) >> 8;
        this.P |= this.znTable[n &= 0xFF];
        return n;
    }

    private final int ROR(int n) {
        int n2 = this.P & 1;
        this.P &= 0x7C;
        this.P |= n & 1;
        n >>= 1;
        this.P |= this.znTable[n |= n2 << 7];
        return n;
    }

    private final int increment(int n) {
        ++n;
        this.setStatusFlags(n &= 0xFF);
        return n;
    }

    private final int decrement(int n) {
        --n;
        this.setStatusFlags(n &= 0xFF);
        return n;
    }

    private final void operateAdd(int n) {
        int n2 = this.P & 1;
        int n3 = this.A + n + n2;
        this.P &= 0x3C;
        this.P |= (~(this.A & n) & (n3 & n) & 0x80) == 0 ? 0 : 64;
        int n4 = 0;
        if (n3 <= 255) {
            n4 = 1;
        }
        this.P |= 1 - n4;
        this.A = n3 & 0xFF;
        this.P |= this.znTable[this.A];
    }

    private final void operateSub(int n) {
        int n2 = ~this.P & 1;
        int n3 = this.A - n - n2;
        this.P &= 0x3C;
        this.P |= (~(this.A & n) & (n3 & n) & 0x80) == 0 ? 0 : 64;
        int n4 = 0;
        if (n3 < 0) {
            n4 = 1;
        }
        this.P |= 1 - n4;
        this.A = n3 & 0xFF;
        this.P |= this.znTable[this.A];
    }

    private final void operateCmp(int n, int n2) {
        int n3 = n - n2;
        this.P &= 0x7C;
        int n4 = 0;
        if (n3 < 0) {
            n4 = 1;
        }
        this.P |= 1 - n4;
        this.P |= this.znTable[n3 & 0xFF];
    }

    private final void operateBit(int n) {
        this.P &= 0x3D;
        this.P |= n & 0xC0;
        this.P |= (this.A & n) != 0 ? 0 : 2;
    }

    private final void branch(String string, int n, boolean bl) {
        byte by = (byte)this.read(this.PC++);
        boolean bl2 = false;
        if ((this.P & n) != 0) {
            bl2 = true;
        }
        if (bl2 == bl) {
            boolean bl3 = false;
            int n2 = this.PC - 2;
            this.checkPageBoundaryCrossing(this.PC + by, this.PC);
            this.PC += by;
            --this.cyclesPending;
            int n3 = this.PC;
            if (this.server != null) {
                int n4 = 0;
                int n5 = 0;
                if (n2 >= 32768 && n2 < 49152) {
                    n4 = 1;
                    n5 = n2 - 32768;
                } else if (n2 >= 49152 && n2 <= (char)-1) {
                    n4 = 2;
                    n5 = n2 - 49152;
                }
                int n6 = 0;
                int n7 = 0;
                if (n3 >= 32768 && n3 < 49152) {
                    n6 = 1;
                    n7 = n3 - 32768;
                } else if (n3 >= 49152 && n3 <= (char)-1) {
                    n6 = 2;
                    n7 = n3 - 49152;
                }
                if (n4 != 0 && n6 != 0) {
                    this.server.message(n4, n5, n6, n7);
                }
            }
        }
    }

    private final void push(int n) {
        this.write(this.S + 256, n);
        --this.S;
        this.S &= 0xFF;
    }

    private final int pop() {
        ++this.S;
        this.S &= 0xFF;
        return this.read(this.S + 256);
    }

    private final void pushWord(int n) {
        this.push(n >> 8 & 0xFF);
        this.push(n & 0xFF);
    }

    private final int popWord() {
        return this.pop() + this.pop() * 256;
    }

    public final void stateLoad(FileInputStream fileInputStream) throws IOException {
        this.A = fileInputStream.read() & 0xFF;
        this.X = fileInputStream.read() & 0xFF;
        this.Y = fileInputStream.read() & 0xFF;
        this.P = fileInputStream.read() & 0xFF;
        this.S = fileInputStream.read() & 0xFF;
        this.PC = fileInputStream.read() & 0xFF;
        this.PC |= (fileInputStream.read() & 0xFF) << 8;
        this.cyclesPending = fileInputStream.read() & 0xFF;
        boolean bl = false;
        if (fileInputStream.read() == 255) {
            bl = true;
        }
        this.halted = bl;
    }

    private final void usedUndocumentedCode(String string) {
        this.deleteScreen();
        this.gui.writeToScreen("Undocumented OpCode: " + string);
    }

    public final void stateSave(FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write(this.A & 0xFF);
        fileOutputStream.write(this.X & 0xFF);
        fileOutputStream.write(this.Y & 0xFF);
        fileOutputStream.write(this.P & 0xFF);
        fileOutputStream.write(this.S & 0xFF);
        fileOutputStream.write(this.PC & 0xFF);
        fileOutputStream.write(this.PC >> 8 & 0xFF);
        fileOutputStream.write(this.cyclesPending & 0xFF);
        fileOutputStream.write(this.halted ? 255 : 0);
    }

    private final /* synthetic */ void this() {
        this.CYCLES_PER_LINE = 118;
        this.resetRequest = false;
        this.stopRequest = false;
        this.stopRequestFulfilled = false;
        this.halted = false;
        this.cycles = new int[]{7, 6, 2, 8, 3, 3, 5, 5, 3, 2, 2, 2, 4, 4, 6, 6, 2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 5, 5, 7, 7, 6, 6, 2, 8, 3, 3, 5, 5, 4, 2, 2, 2, 4, 4, 6, 6, 2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 5, 5, 7, 7, 6, 6, 2, 8, 3, 3, 5, 5, 3, 2, 2, 2, 3, 4, 6, 6, 2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 5, 5, 7, 7, 4, 6, 2, 8, 3, 3, 5, 5, 4, 2, 2, 2, 5, 4, 6, 6, 4, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 5, 5, 7, 7, 2, 6, 2, 6, 3, 3, 3, 3, 2, 2, 2, 2, 4, 4, 4, 4, 2, 6, 2, 6, 4, 4, 4, 4, 2, 5, 2, 5, 5, 5, 5, 5, 2, 6, 2, 6, 3, 3, 3, 3, 2, 2, 2, 2, 4, 4, 4, 4, 2, 5, 2, 5, 4, 4, 4, 4, 2, 4, 2, 4, 4, 4, 4, 4, 2, 6, 2, 8, 3, 3, 5, 5, 2, 2, 2, 2, 4, 4, 6, 6, 2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 5, 5, 7, 7, 2, 6, 2, 8, 3, 3, 5, 5, 2, 2, 2, 2, 4, 4, 6, 6, 2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 5, 5, 7, 7};
        int[] nArray = new int[256];
        nArray[0] = 2;
        nArray[128] = 128;
        nArray[129] = 128;
        nArray[130] = 128;
        nArray[131] = 128;
        nArray[132] = 128;
        nArray[133] = 128;
        nArray[134] = 128;
        nArray[135] = 128;
        nArray[136] = 128;
        nArray[137] = 128;
        nArray[138] = 128;
        nArray[139] = 128;
        nArray[140] = 128;
        nArray[141] = 128;
        nArray[142] = 128;
        nArray[143] = 128;
        nArray[144] = 128;
        nArray[145] = 128;
        nArray[146] = 128;
        nArray[147] = 128;
        nArray[148] = 128;
        nArray[149] = 128;
        nArray[150] = 128;
        nArray[151] = 128;
        nArray[152] = 128;
        nArray[153] = 128;
        nArray[154] = 128;
        nArray[155] = 128;
        nArray[156] = 128;
        nArray[157] = 128;
        nArray[158] = 128;
        nArray[159] = 128;
        nArray[160] = 128;
        nArray[161] = 128;
        nArray[162] = 128;
        nArray[163] = 128;
        nArray[164] = 128;
        nArray[165] = 128;
        nArray[166] = 128;
        nArray[167] = 128;
        nArray[168] = 128;
        nArray[169] = 128;
        nArray[170] = 128;
        nArray[171] = 128;
        nArray[172] = 128;
        nArray[173] = 128;
        nArray[174] = 128;
        nArray[175] = 128;
        nArray[176] = 128;
        nArray[177] = 128;
        nArray[178] = 128;
        nArray[179] = 128;
        nArray[180] = 128;
        nArray[181] = 128;
        nArray[182] = 128;
        nArray[183] = 128;
        nArray[184] = 128;
        nArray[185] = 128;
        nArray[186] = 128;
        nArray[187] = 128;
        nArray[188] = 128;
        nArray[189] = 128;
        nArray[190] = 128;
        nArray[191] = 128;
        nArray[192] = 128;
        nArray[193] = 128;
        nArray[194] = 128;
        nArray[195] = 128;
        nArray[196] = 128;
        nArray[197] = 128;
        nArray[198] = 128;
        nArray[199] = 128;
        nArray[200] = 128;
        nArray[201] = 128;
        nArray[202] = 128;
        nArray[203] = 128;
        nArray[204] = 128;
        nArray[205] = 128;
        nArray[206] = 128;
        nArray[207] = 128;
        nArray[208] = 128;
        nArray[209] = 128;
        nArray[210] = 128;
        nArray[211] = 128;
        nArray[212] = 128;
        nArray[213] = 128;
        nArray[214] = 128;
        nArray[215] = 128;
        nArray[216] = 128;
        nArray[217] = 128;
        nArray[218] = 128;
        nArray[219] = 128;
        nArray[220] = 128;
        nArray[221] = 128;
        nArray[222] = 128;
        nArray[223] = 128;
        nArray[224] = 128;
        nArray[225] = 128;
        nArray[226] = 128;
        nArray[227] = 128;
        nArray[228] = 128;
        nArray[229] = 128;
        nArray[230] = 128;
        nArray[231] = 128;
        nArray[232] = 128;
        nArray[233] = 128;
        nArray[234] = 128;
        nArray[235] = 128;
        nArray[236] = 128;
        nArray[237] = 128;
        nArray[238] = 128;
        nArray[239] = 128;
        nArray[240] = 128;
        nArray[241] = 128;
        nArray[242] = 128;
        nArray[243] = 128;
        nArray[244] = 128;
        nArray[245] = 128;
        nArray[246] = 128;
        nArray[247] = 128;
        nArray[248] = 128;
        nArray[249] = 128;
        nArray[250] = 128;
        nArray[251] = 128;
        nArray[252] = 128;
        nArray[253] = 128;
        nArray[254] = 128;
        nArray[255] = 128;
        this.znTable = nArray;
    }

    public N6502(NES nES, GUI gUI) {
        this.this();
        this.nes = nES;
        this.gui = gUI;
        this.cpu = this.nes.cpu;
    }
}

