/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class NES {
    protected CPU cpu;
    protected JoyPad joyPad1;
    protected JoyPad joyPad2;
    protected GUI gui;
    protected Mapper mapper;
    protected MemoryManager memory;
    protected PPU ppu;
    protected Palette palette;
    private boolean noCartLoaded;
    protected String currentCartFileName;
    public String lastOpenedCartFileName;
    public boolean useUndocumentedOpCodes;

    public final void init(GUI gUI) {
        this.gui = gUI;
        this.joyPad1 = new JoyPad(1);
        this.joyPad2 = new JoyPad(2);
        this.cpu = new CPU(this, this.gui);
        this.ppu = new PPU(this, this.gui);
        this.memory = new MemoryManager(this, this.gui);
    }

    public final boolean cartLoad(File file) {
        return this.cartLoad(file.toString());
    }

    public final boolean cartLoad(String string) {
        this.gui.tvController.blankScreen();
        try {
            this.cpu.cpuLoadRom(string);
        }
        catch (InvalidOrUnsupportedROMException invalidOrUnsupportedROMException) {
            DavOS.MsgBox(invalidOrUnsupportedROMException.getMessage());
            return false;
        }
        this.cpu.cpuStop();
        this.noCartLoaded = true;
        this.gui.showMenuNoRom();
        this.cpu.cpuRun();
        this.noCartLoaded = false;
        this.gui.showMenuRom();
        this.currentCartFileName = string;
        return true;
    }

    public final void cartUnload() {
        if (this.noCartLoaded) {
            return;
        }
        this.cpu.cpuStop();
        this.noCartLoaded = true;
        this.currentCartFileName = "";
        this.gui.showMenuNoRom();
        System.gc();
    }

    public final boolean isCartRunning() {
        return this.noCartLoaded ^ true;
    }

    public final String getCartFileName() {
        return this.currentCartFileName;
    }

    public final void reset() {
        this.cpu.cpuReset();
    }

    public final void stateLoad() {
        FileInputStream fileInputStream;
        this.gui.loadStateRequest = false;
        String string = DavOS.getFileName(this.currentCartFileName);
        try {
            File file = new File("NESCafe - " + string + ".nss");
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            DavOS.MsgBox("No Committed State Found for Cartridge...");
            return;
        }
        catch (Exception exception) {
            DavOS.MsgBox("A Committed State could not be loaded...");
            return;
        }
        try {
            this.cpu.stateLoad(fileInputStream);
            this.memory.stateLoad(fileInputStream);
            this.ppu.stateLoad(fileInputStream);
            int n = fileInputStream.read();
            this.mapper.stateLoad(fileInputStream);
            this.joyPad1.stateLoad(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            DavOS.MsgBox("The NESCafe Saved-State file is corrupt.");
            return;
        }
        this.cpu.setCPUPause(false);
        this.gui.writeToScreen("State Successfully Loaded...");
    }

    public final void stateSave() {
        FileOutputStream fileOutputStream;
        this.gui.saveStateRequest = false;
        String string = DavOS.getFileName(this.currentCartFileName);
        try {
            File file = new File("NESCafe - " + string + ".nss");
            fileOutputStream = new FileOutputStream(file);
        }
        catch (Exception exception) {
            DavOS.MsgBox("A Committed State could not be saved.");
            return;
        }
        try {
            this.cpu.stateSave(fileOutputStream);
            this.memory.stateSave(fileOutputStream);
            this.ppu.stateSave(fileOutputStream);
            fileOutputStream.write(this.mapper.getMapperNumber() & 0xFF);
            this.mapper.stateSave(fileOutputStream);
            this.joyPad1.stateSave(fileOutputStream);
            this.joyPad2.stateSave(fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            DavOS.MsgBox("The NESCafe Saved-State File could not be Saved.");
            return;
        }
        this.gui.writeToScreen("State Successfully Saved...");
    }

    private final /* synthetic */ void this() {
        this.palette = new Palette();
        this.noCartLoaded = true;
        this.currentCartFileName = "";
        this.lastOpenedCartFileName = ".";
        this.useUndocumentedOpCodes = false;
    }

    public NES() {
        this.this();
        this.noCartLoaded = true;
        this.currentCartFileName = "";
    }
}

