/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class NESCart {
    protected static final int ERROR_NONE = 0;
    protected static final int ERROR_FILE_FORMAT = 16;
    protected static final int ERROR_UNSUPPORTED_MAPPER = 18;
    protected static final int ERROR_MISSING_PROGRAM_ROM = 19;
    protected static final int ERROR_IO = 20;
    private GUI gui;
    private NES nes;
    private int MapperNumber;
    private String MapperName;
    private boolean supported;
    private int errorCode;
    private int numProgramROMBanks;
    private int numCharacterROMBanks;
    private int[] progROM;
    private int[] charROM;
    protected int[] trainerROM;
    private boolean vMirroring;
    private boolean fourScreenNT;
    protected boolean hasTrainer;
    protected boolean hasSaveRAM;

    public final boolean loadRom(String string) {
        InputStream inputStream;
        this.errorCode = 0;
        try {
            URL uRL = new URL(DeconstructulatorApplet.base, "smb.nes");
            inputStream = uRL.openStream();
            if (inputStream.read() != 78 || inputStream.read() != 69 || inputStream.read() != 83 || inputStream.read() != 26) {
                inputStream.close();
                this.errorCode = 16;
                return true;
            }
            this.numProgramROMBanks = inputStream.read();
            this.numCharacterROMBanks = inputStream.read();
            int n = inputStream.read();
            boolean bl = false;
            if ((n & 1) != 0) {
                bl = true;
            }
            this.vMirroring = bl;
            boolean bl2 = false;
            if ((n & 2) != 0) {
                bl2 = true;
            }
            this.hasSaveRAM = bl2;
            boolean bl3 = false;
            if ((n & 4) != 0) {
                bl3 = true;
            }
            this.hasTrainer = bl3;
            boolean bl4 = false;
            if ((n & 8) != 0) {
                bl4 = true;
            }
            this.fourScreenNT = bl4;
            int n2 = n >> 4 & 0xF;
            int n3 = inputStream.read() & 0xF0;
            this.MapperNumber = n2 | n3;
            int n4 = 0;
            while (n4 < 8) {
                if (inputStream.read() != 0) {
                    this.MapperNumber &= 0xF;
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            this.errorCode = 20;
            return true;
        }
        switch (this.MapperNumber) {
            case 0: {
                this.MapperName = "No Mapper";
                this.supported = true;
                break;
            }
            case 1: {
                this.MapperName = "Nintendo MMC1";
                this.supported = true;
                break;
            }
            case 2: {
                this.MapperName = "Simple ROM Switch (UNROM)";
                this.supported = true;
                break;
            }
            case 3: {
                this.MapperName = "Simple VROM Switch (CNROM)";
                this.supported = true;
                break;
            }
            case 4: {
                this.MapperName = "Nintendo MMC3";
                this.supported = true;
                break;
            }
            case 5: {
                this.MapperName = "Nintendo MMC5";
                this.supported = false;
                break;
            }
            case 6: {
                this.MapperName = "Konami FFE F4xxx";
                this.supported = false;
                break;
            }
            case 7: {
                this.MapperName = "Rare AOROM";
                this.supported = true;
                break;
            }
            case 8: {
                this.MapperName = "Konami FFE F3xxx";
                this.supported = false;
                break;
            }
            case 9: {
                this.MapperName = "Nintendo MMC2";
                this.supported = true;
                break;
            }
            case 10: {
                this.MapperName = "Nintendo MMC4";
                this.supported = false;
                break;
            }
            case 11: {
                this.MapperName = "Color Dreams";
                this.supported = false;
                break;
            }
            case 15: {
                this.MapperName = "100-in-1";
                this.supported = false;
                break;
            }
            case 16: {
                this.MapperName = "Bandai";
                this.supported = false;
                break;
            }
            case 17: {
                this.MapperName = "Konami FFE F8xxx";
                this.supported = false;
                break;
            }
            case 18: {
                this.MapperName = "Jaleco SS8806";
                this.supported = false;
                break;
            }
            case 19: {
                this.MapperName = "Namcot 106";
                this.supported = false;
                break;
            }
            case 21: {
                this.MapperName = "Konami VRC4";
                this.supported = false;
                break;
            }
            case 22: {
                this.MapperName = "Konami VRC2 type A";
                this.supported = false;
                break;
            }
            case 23: {
                this.MapperName = "Konami VRC2 type B";
                this.supported = false;
                break;
            }
            case 24: {
                this.MapperName = "Konami VRC6";
                this.supported = false;
                break;
            }
            case 32: {
                this.MapperName = "Irem G-101";
                this.supported = false;
                break;
            }
            case 40: {
                this.MapperName = "SM2J";
                this.supported = true;
                break;
            }
            default: {
                this.MapperName = "Unknown (0x" + DavOS.hex(this.MapperNumber, 2) + ')';
                this.supported = false;
            }
        }
        if (!this.supported) {
            this.errorCode = 18;
            return true;
        }
        if (this.numProgramROMBanks == 0) {
            this.errorCode = 19;
            return true;
        }
        try {
            if (this.hasTrainer) {
                this.trainerROM = new int[512];
                int n = 0;
                while (n < this.trainerROM.length) {
                    this.trainerROM[n] = (byte)inputStream.read() + 256 & 0xFF;
                    ++n;
                }
            }
            this.progROM = new int[16384 * this.numProgramROMBanks];
            int n = 0;
            while (n < this.progROM.length) {
                this.progROM[n] = (byte)inputStream.read() + 256 & 0xFF;
                ++n;
            }
            this.charROM = new int[8192 * this.numCharacterROMBanks];
            n = 0;
            while (n < this.charROM.length) {
                this.charROM[n] = (byte)inputStream.read() + 256 & 0xFF;
                ++n;
            }
            inputStream.close();
            return false;
        }
        catch (IOException iOException) {
            this.errorCode = 20;
            return true;
        }
    }

    public final int[] getCharROM() {
        return this.charROM;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final boolean getFourScreenNT() {
        return this.fourScreenNT;
    }

    public final String getMapperName() {
        return this.MapperName;
    }

    public final int getMapperNumber() {
        return this.MapperNumber;
    }

    public final boolean getMirroring() {
        return this.vMirroring;
    }

    public final int[] getProgROM() {
        return this.progROM;
    }

    public final boolean isMapperSupported() {
        return this.supported;
    }

    private final /* synthetic */ void this() {
        this.MapperNumber = 0;
        this.MapperName = "Non Loaded";
        this.supported = false;
        this.errorCode = 0;
        this.numProgramROMBanks = 0;
        this.numCharacterROMBanks = 0;
        this.vMirroring = false;
        this.fourScreenNT = false;
        this.hasTrainer = false;
        this.hasSaveRAM = false;
    }

    public NESCart(GUI gUI, NES nES) {
        this.this();
        this.gui = gUI;
        this.nes = nES;
    }
}

