/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.io.File;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class TVController
extends Frame
implements Runnable {
    protected static int screenWidth = 256;
    protected static int screenHeight = 240;
    static final int screenMagnification = 1;
    static int screenWidthMag = screenWidth;
    static int screenHeightMag = screenHeight;
    private int actualFrameNum;
    private File filePause;
    private File fileWait;
    protected int frameRate;
    protected int frameSkip;
    protected int scanLine;
    protected boolean showFPS;
    public int[] palette;
    private int[] videoBuffer;
    private Image consoleImage;
    MemoryImageSource consoleSource;
    public Image currentImage;
    private GUI gui;
    private NES nes;
    private Image waitImage;
    private Image pauseImage;
    private Thread counter;
    private boolean skipThisFrame;
    private int framesSkipped;
    private boolean BW;
    private float hue;
    private float tint;

    private final void getImages() {
        this.filePause = new File("Pause.gif");
        this.fileWait = new File("Wait.gif");
        try {
            this.waitImage = DavOS.getImageFromFile("Wait.gif");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.pauseImage = DavOS.getImageFromFile("Pause.gif");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void blankScreen() {
        if (this.gui == null) {
            return;
        }
        int n = 256;
        int n2 = 256;
        boolean bl = false;
        boolean bl2 = false;
        if (this.waitImage == null) {
            return;
        }
        this.currentImage = this.waitImage;
    }

    public final void deleteDisplay() {
        int n;
        if (this.gui == null) {
            return;
        }
        int n2 = 8;
        while (n2 < screenHeight - 8) {
            n = 8;
            while (n < screenWidth - 8) {
                this.videoBuffer[n2 * TVController.screenWidth + n] = -16777216;
                ++n;
            }
            ++n2;
        }
        this.consoleSource.newPixels();
        n2 = 256;
        n = 256;
        boolean bl = false;
        boolean bl2 = false;
        this.currentImage = this.consoleImage;
    }

    private final void blitzScreen() {
        int n = 256;
        int n2 = 256;
        boolean bl = false;
        boolean bl2 = false;
        if (this.nes.cpu.getCPUPause()) {
            if (this.pauseImage == null) {
                return;
            }
            this.currentImage = this.pauseImage;
            return;
        }
        if (this.gui.waitMode) {
            if (this.waitImage == null) {
                return;
            }
            this.currentImage = this.waitImage;
            return;
        }
        if (!this.nes.isCartRunning()) {
            this.blankScreen();
            return;
        }
        this.consoleSource.newPixels();
        this.currentImage = this.consoleImage;
        this.gui.update();
        if (this.showFPS) {
            System.out.println(this.frameRate + " fps");
        }
    }

    public final void drawScreen(boolean bl) {
        if (this.isSkipFrame() ^ true | bl) {
            this.blitzScreen();
        }
        ++this.actualFrameNum;
    }

    public final void fpsHide() {
        this.showFPS = false;
    }

    public final void fpsShow() {
        this.showFPS = true;
    }

    public final boolean setScanLineNum(int n) {
        this.scanLine = n;
        if (this.scanLine == 0) {
            ++this.framesSkipped;
            if (this.framesSkipped <= this.frameSkip) {
                this.skipThisFrame = true;
            } else {
                this.framesSkipped = 0;
                this.skipThisFrame = false;
            }
            this.palette = this.nes.palette.palette;
        }
        return this.skipThisFrame;
    }

    private final boolean isSkipFrame() {
        return this.skipThisFrame;
    }

    public final void run() {
        while (true) {
            this.actualFrameNum = 0;
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.frameRate = this.actualFrameNum / 5;
        }
    }

    public final void saveScreen() {
        try {
            new SaveImage(this.consoleImage);
            this.gui.writeToScreen("Screenshot saved...");
        }
        catch (Exception exception) {
            this.gui.writeToScreen("Screenshot failed!");
        }
    }

    public final void setFrameSkip(int n) {
        this.frameSkip = n;
    }

    public final void setPixel(int n, int n2) {
        this.videoBuffer[this.scanLine << 8 | n] = this.palette[n2 % 64];
    }

    public final void setPixels(int[] nArray) {
        if (nArray.length < 256) {
            return;
        }
        int n = 8;
        while (n < 248) {
            this.videoBuffer[this.scanLine << 8 | n] = this.palette[nArray[n]];
            ++n;
        }
    }

    public final int getPixel(int n, int n2) {
        int n3 = n2 << 8 | n;
        if (n3 >= this.videoBuffer.length) {
            return 0;
        }
        return this.videoBuffer[n3];
    }

    private final void startFPSPolling() {
        this.counter = new Thread(this);
        this.counter.start();
    }

    public final void incTint() {
        this.tint += (float)5;
        if (this.tint > 255.0f) {
            this.tint = 255.0f;
        }
        this.nes.palette.calcPalette(this.tint, this.hue, this.BW);
        int n = (int)(this.tint / 256.0f * 100.0f);
        this.gui.writeToScreen("Tint = " + n + '%');
    }

    public final void decTint() {
        this.tint -= (float)5;
        if (this.tint < 0.0f) {
            this.tint = 0.0f;
        }
        this.nes.palette.calcPalette(this.tint, this.hue, this.BW);
        int n = (int)(this.tint / 256.0f * 100.0f);
        this.gui.writeToScreen("Tint = " + n + '%');
    }

    public final void incHue() {
        this.hue += (float)5;
        if (this.hue > 255.0f) {
            this.hue = 255.0f;
        }
        this.nes.palette.calcPalette(this.tint, this.hue, this.BW);
        int n = (int)(this.hue / 256.0f * 100.0f);
        this.gui.writeToScreen("Hue = " + n + '%');
    }

    public final void decHue() {
        this.hue -= (float)5;
        if (this.hue < 0.0f) {
            this.hue = 0.0f;
        }
        this.nes.palette.calcPalette(this.tint, this.hue, this.BW);
        int n = (int)(this.hue / 256.0f * 100.0f);
        this.gui.writeToScreen("Hue = " + n + '%');
    }

    public final void toggleBlackWhite() {
        this.BW ^= true;
        this.nes.palette.calcPalette(this.tint, this.hue, this.BW);
        this.gui.writeToScreen(this.BW ? "Black and White Mode" : "Colour Mode");
    }

    private final /* synthetic */ void this() {
        this.actualFrameNum = 0;
        this.frameRate = 0;
        this.frameSkip = 0;
        this.scanLine = 0;
        this.showFPS = false;
        this.videoBuffer = new int[screenWidth * screenHeight];
        this.skipThisFrame = false;
        this.framesSkipped = 0;
        this.BW = false;
        this.hue = 128.0f;
        this.tint = 128.0f;
    }

    public TVController(NES nES, GUI gUI) {
        this.this();
        this.nes = nES;
        this.gui = gUI;
        int n = screenWidth;
        int n2 = screenHeight;
        this.consoleSource = new MemoryImageSource(n, n2, this.videoBuffer, 0, 256);
        this.consoleSource.setAnimated(true);
        this.consoleImage = this.createImage(this.consoleSource);
        this.nes.palette.calcPalette(this.tint, this.hue, this.BW);
        this.palette = this.nes.palette.palette;
        this.startFPSPolling();
        this.getImages();
        System.gc();
    }
}

